/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.ExprTypeException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeFunctions
extends TestCase {
    private static final double accuracyExact = 0.0;
    private static final double accuracyClose = 1.0E-6;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeFunctions.class);
        ts.setName(Utils.classShortName(TestNodeFunctions.class));
        return ts;
    }

    public void testStr1() {
        NodeValue nv = NodeValue.makeNodeInteger(56L);
        NodeValue s = NodeFunctions.str(nv);
        TestNodeFunctions.assertEquals((String)"56", (String)s.getString());
    }

    public void testStr2() {
        NodeValue nv = NodeValue.makeInteger(56L);
        NodeValue s = NodeFunctions.str(nv);
        TestNodeFunctions.assertEquals((String)"56", (String)s.getString());
    }

    public void testStr3() {
        NodeValue nv = NodeValue.makeNode("abc", "fr", (String)null);
        NodeValue s = NodeFunctions.str(nv);
        TestNodeFunctions.assertEquals((String)"abc", (String)s.getString());
    }

    public void testStr4() {
        Node n = Node.createAnon();
        try {
            String s = NodeFunctions.str(n);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype1() {
        NodeValue nv = NodeValue.makeInteger(5L);
        Node n = nv.asNode();
        Node r = NodeFunctions.datatype(n);
        TestNodeFunctions.assertEquals((Object)XSD.integer.asNode(), (Object)r);
    }

    public void testDatatype2() {
        NodeValue nv = NodeValue.makeInteger(5L);
        NodeValue r = NodeFunctions.datatype(nv);
        NodeValue e2 = NodeValue.makeNode(XSD.integer.asNode());
        TestNodeFunctions.assertEquals((Object)e2, (Object)r);
    }

    public void testDatatype3() {
        NodeValue nv = NodeValue.makeString("abc");
        NodeValue r = NodeFunctions.datatype(nv);
        NodeValue e2 = NodeValue.makeNode(XSD.xstring.asNode());
        TestNodeFunctions.assertEquals((Object)e2, (Object)r);
    }

    public void testDatatype4() {
        NodeValue nv = NodeValue.makeNode("abc", "fr", (String)null);
        try {
            NodeValue r = NodeFunctions.datatype(nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype5() {
        try {
            NodeValue nv = NodeValue.makeNode(Node.createURI((String)"http://example"));
            NodeValue r = NodeFunctions.datatype(nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype6() {
        NodeValue nv = NodeValue.makeNode(Node.createAnon());
        try {
            NodeValue r = NodeFunctions.datatype(nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testLang1() {
        Node n = Node.createLiteral((String)"abc", (String)"en-gb", null);
        TestNodeFunctions.assertEquals((String)"en-gb", (String)NodeFunctions.lang(n));
    }

    public void testLang2() {
        NodeValue nv = NodeValue.makeNode("abc", "en", (String)null);
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("en");
        TestNodeFunctions.assertEquals((Object)e2, (Object)r);
    }

    public void testLang3() {
        NodeValue nv = NodeValue.makeInteger(5L);
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("");
        TestNodeFunctions.assertEquals((Object)e2, (Object)r);
    }

    public void testLang4() {
        NodeValue nv = NodeValue.makeNode(Node.createLiteral((String)"simple"));
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("");
        TestNodeFunctions.assertEquals((Object)e2, (Object)r);
    }

    public void testLang5() {
        NodeValue nv = NodeValue.makeNode(Node.createURI((String)"http://example/"));
        try {
            NodeValue r = NodeFunctions.lang(nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testLangMatches1() {
        NodeValue nv = NodeValue.makeString("en");
        NodeValue pat = NodeValue.makeString("en");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
        TestNodeFunctions.assertFalse((boolean)NodeValue.FALSE.equals(r));
    }

    public void testLangMatches2() {
        NodeValue nv = NodeValue.makeString("en");
        NodeValue pat = NodeValue.makeString("fr");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
        TestNodeFunctions.assertFalse((boolean)NodeValue.TRUE.equals(r));
    }

    public void testLangMatches3() {
        NodeValue nv = NodeValue.makeString("en-gb");
        NodeValue pat = NodeValue.makeString("en-gb");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches4() {
        NodeValue nv = NodeValue.makeString("en-gb");
        NodeValue pat = NodeValue.makeString("en");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches5() {
        NodeValue nv = NodeValue.makeString("abc");
        NodeValue pat = NodeValue.makeString("*");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches6() {
        NodeValue nv = NodeValue.makeString("x-y-z");
        NodeValue pat = NodeValue.makeString("x");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches7() {
        NodeValue nv = NodeValue.makeString("x");
        NodeValue pat = NodeValue.makeString("x-y-z");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsIRI_1() {
        NodeValue nv = NodeValue.makeNode(Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsIRI_2() {
        NodeValue nv = NodeValue.makeNode(Node.createLiteral((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsBlank1() {
        NodeValue nv = NodeValue.makeNode(Node.createAnon());
        NodeValue r = NodeFunctions.isBlank(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsBlank2() {
        NodeValue nv = NodeValue.makeNode(Node.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isBlank(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsBlank3() {
        NodeValue nv = NodeValue.makeNode(Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isBlank(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsLiteral1() {
        NodeValue nv = NodeValue.makeNode(Node.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isLiteral(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsLiteral2() {
        NodeValue nv = NodeValue.makeNode(Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isLiteral(nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }
}

