/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSerialization
extends TestCase {
    PrefixMapping pmap1 = new PrefixMappingImpl();

    public TestSerialization() {
        this.pmap1.setNsPrefix("", "http://default/");
        this.pmap1.setNsPrefix("ex", "http://example/x#");
        this.pmap1.setNsPrefix("x", "x:");
    }

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSerialization.class);
        ts.setName(Utils.classShortName(TestSerialization.class));
        return ts;
    }

    public void test_URI_1() {
        this.fmtURI("http://elsewhere/", "<http://elsewhere/>", this.pmap1);
    }

    public void test_URI_2() {
        this.fmtURI("http://example/", "<http://example/>", this.pmap1);
    }

    public void test_QName_1() {
        this.fmtURI("http://example/x#abc", "ex:abc", this.pmap1);
    }

    public void test_QName_2() {
        this.fmtURI("http://example/x#", "ex:", this.pmap1);
    }

    public void test_QName_3() {
        this.fmtURI("http://default/x", ":x", this.pmap1);
    }

    public void test_QName_4() {
        this.fmtURI("http://default/", ":", this.pmap1);
    }

    public void test_QName_5() {
        this.fmtURI("http://default/0", "<http://default/0>", this.pmap1);
    }

    public void test_QName_6() {
        this.fmtURI("http://example/x#_1", "ex:_1", this.pmap1);
    }

    public void test_Dots_1() {
        this.fmtURI("http://example/x#a.b", "ex:a.b", this.pmap1);
    }

    public void test_Dots_2() {
        this.fmtURI("http://example/x#a.b.", "<http://example/x#a.b.>", this.pmap1);
    }

    public void test_Dots_3() {
        this.fmtURI("http://example/x#.b", "<http://example/x#.b>", this.pmap1);
    }

    public void test_URI_NoQName_1() {
        this.fmtURI("http://example/x#-", "<http://example/x#->", this.pmap1);
    }

    public void test_URI_NoQName_2() {
        this.fmtURI("http://example/x#-a", "<http://example/x#-a>", this.pmap1);
    }

    public void test_URI_NoQName_3() {
        this.fmtURI("http://example/x#.", "<http://example/x#.>", this.pmap1);
    }

    private void fmtURI(String uriStr, String expected, PrefixMapping pmap) {
        String actual = FmtUtils.stringForURI(uriStr, pmap);
        TestSerialization.assertEquals((String)expected, (String)actual);
        if (!expected.equals(actual)) {
            TestSerialization.fail((String)(expected + " => " + actual));
        }
    }
}

