/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetUtils {
    private static Log log = LogFactory.getLog((Class)DatasetUtils.class);

    public static Dataset createDataset(String uri, List namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset createDataset(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        String absURI;
        String sourceURI;
        Iterator iter;
        DataSourceImpl ds = new DataSourceImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        ds.setDefaultModel(GraphUtils.makeDefaultModel());
        if (uriList != null) {
            iter = uriList.iterator();
            while (iter.hasNext()) {
                sourceURI = (String)iter.next();
                absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(unnamed): " + sourceURI));
                fileManager.readModel(ds.getDefaultModel(), sourceURI, absURI, null);
            }
        }
        if (namedSourceList != null) {
            iter = namedSourceList.iterator();
            while (iter.hasNext()) {
                sourceURI = (String)iter.next();
                absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(named): " + sourceURI + " as " + absURI));
                Model m = GraphUtils.makeDefaultModel();
                fileManager.readModel(m, sourceURI, absURI, null);
                ds.addNamedModel(absURI, m);
            }
        }
        return ds;
    }

    public static DatasetGraph createDatasetGraph(String uri, List namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDatasetGraph(uriList, namedSourceList, fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (uriList != null) {
            Model m = GraphUtils.makeDefaultModel();
            Iterator iter = uriList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(unnamed): " + sourceURI));
                fileManager.readModel(m, sourceURI, absURI, null);
            }
            ds.setDefaultGraph(m.getGraph());
        } else {
            ds.setDefaultGraph(GraphUtils.makeDefaultModel().getGraph());
        }
        if (namedSourceList != null) {
            Iterator iter = namedSourceList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(named): " + sourceURI + " as " + absURI));
                Model m = fileManager.loadModel(sourceURI, absURI, null);
                ds.addNamedGraph(absURI, m.getGraph());
            }
        }
        return ds;
    }
}

