/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.lang.sparql.ParseException;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.query.lang.sparql.Token;
import com.hp.hpl.jena.query.lang.sparql.TokenMgrError;
import java.io.StringReader;
import java.util.List;
import java.util.ListIterator;

public class ExprUtils {
    public static String joinList(List args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr ex;
            if (!first) {
                s.append(sep);
            }
            if ((ex = (Expr)iter.next()) instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                s.append(nv.asQuotedString());
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }

    public static Expr parseExpr(String s) {
        Query query2 = QueryFactory.make();
        query2.setPrefixMapping(Constants.getGlobalPrefixMap());
        return ExprUtils.parseExpr(query2, s, true);
    }

    public static Expr parseExpr(Query query2, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query2);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        try {
            Query query2 = QueryFactory.make();
            query2.setPrefixMapping(Constants.getGlobalPrefixMap());
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query2);
            Node n = parser.GraphTerm();
            Token t = parser.getNextToken();
            if (t.kind != 0) {
                throw ExprUtils.makeException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
            }
            NodeValue nv = NodeValue.makeNode(n);
            return nv;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }
}

