/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.net.URI;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;

import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FilterTypeAssertion extends FilterAssertion implements IFilterTypeAssertion {
	private Log log = LogFactory.getLog(FilterTypeAssertion.class);

	private static final PropertyNode typeProperty_ = new PropertyNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");

	private FilterContext filterContext_ = null;

	private Context idasContext_ = null;

	private CompoundCondition condition_ = null;

	public FilterTypeAssertion(Context context) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::FilterTypeAssertion");
		idasContext_ = context;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IFilterTypeAssertion#setAssertionValue(java.net.URI)
	 */
	public void setAssertionValue(URI assertion) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::setAssertionValue");
		setID(assertion);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#getCondition()
	 */
	public ICondition getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::getCondition");
		if (condition_ == null)
			throw new IdASException("Can't return condition. FilterAttributeAssertion should be initialized before.");
		return condition_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#init(org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext)
	 */
	public void init(FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::init");
		filterContext_ = filterContext;
		if (idasContext_ == null)
			throw new IdASException("Can't init FilterTypeAssertion because idasContext is null.");
		if (type_ == null)
			throw new IdASException("Can't init FilterTypeAssertion because type is null.");
		String type = type_.toString();
		ArrayList types = new ArrayList();
		types.add(type);
		if (includeSubtypes_) {
			OntProperty prop = idasContext_.getOntProperty(type);
			ExtendedIterator it = prop.listSubProperties();
			while (it.hasNext()) {
				OntProperty subProp = (OntProperty)it.next();
				types.add(subProp.getURI());
			}
		}
		condition_ = new CompoundCondition(Filter.OP_OR);
		GraphPattern pattern = filterContext_.registerPattern(new GraphPattern(filterContext_.getSubjectNode(), typeProperty_, new TypeNode(), null));
		TypeNode typeNode = (TypeNode)pattern.getObject();
		int typesCount = types.size();
		for (int i = 0; i < typesCount; i++) {
			String subType = (String)types.get(i);
			condition_.addCondition(new TypeCondition(typeNode, subType));
		}
	}
}
