/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphPattern {
	private Log log = LogFactory.getLog(GraphPattern.class);

	private GraphPattern parent_;

	private INode subject_;

	private INode predicate_;

	private INode object_;

	private String type_ = null;

	public GraphPattern(INode subj, INode predicate, INode obj, GraphPattern parent) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::GraphPattern");
		subject_ = subj;
		predicate_ = predicate;
		object_ = obj;
		parent_ = parent;
	}

	public String getFullPath() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::getFullPath");
		if (parent_ != null)
			return parent_.getType() + getType();
		else
			return getType();
	}

	public String getType() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::getType");
		if (type_ == null) {
			type_ = subject_.getType() + predicate_.getType() + object_.getType();
		}
		return type_;
	}

	public boolean equals(Object o) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::equals");
		if (o instanceof GraphPattern) {
			GraphPattern ext = (GraphPattern) o;
			return getFullPath().equals(ext.getFullPath());
		}
		return false;
	}

	public StringBuffer asQueryElement() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::asQueryElement");
		StringBuffer buf = new StringBuffer();
		buf.append(subject_.asQueryElement());
		buf.append(" ");
		buf.append(predicate_.asQueryElement());
		buf.append(" ");
		buf.append(object_.asQueryElement());
		return buf;
	}

	public void setParent(GraphPattern pattern) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::setParent");
		parent_ = pattern;
	}

	public INode getSubject() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::getSubject");
		return subject_;
	}

	public INode getPredicate() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::getPredicate");
		return predicate_;
	}

	public INode getObject() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern::getObject");
		return object_;
	}

}
