/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.model.impl;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.model.IDisplayData;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class DisplayData implements IDisplayData {
	private Log log = LogFactory.getLog(DisplayData.class);

	protected ContextModel ctx = null;
	
	protected Individual idd = null;
	
	protected String label = null;
	protected String description = null;
	protected int order = 0;
	protected URL image = null;
	
	protected DisplayData(ContextModel ctx, Individual idd) {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::DisplayData");
		this.ctx = ctx;
		this.idd = idd;
		initialize();
	}
	
	protected void initialize() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::initialize");
		RDFNode n = idd.getPropertyValue(ctx.getP_DD_Label());
		if (n != null && n.isLiteral()) {
			Literal l = (Literal) n.as(Literal.class);
			if (l != null) {
				label = l.getString();
			}
		}
		n = idd.getPropertyValue(ctx.getP_DD_Desc());
		if (n != null && n.isLiteral()) {
			Literal l = (Literal) n.as(Literal.class);
			if (l != null) {
				description = l.getString();
			}
		}
		n = idd.getPropertyValue(ctx.getP_DD_Order());
		if (n != null && n.isLiteral()) {
			Literal l = (Literal) n.as(Literal.class);
			if (l != null) {
				order = l.getInt();
			}
		}
		n = idd.getPropertyValue(ctx.getP_DD_Image());
		if (n != null && n.isLiteral()) {
			Literal l = (Literal) n.as(Literal.class);
			if (l != null) {
				try {
					image = new URL(l.getString());
				} catch (MalformedURLException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/*
	 * @see org.eclipse.higgins.idas.model.IDisplayData#getLabel()
	 */
	public String getLabel() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::getLabel");
		return label;
	}

	/*
	 * @see org.eclipse.higgins.idas.model.IDisplayData#getDescription()
	 */
	public String getDescription() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::getDescription");
		return description;
	}

	/*
	 * @see org.eclipse.higgins.idas.model.IDisplayData#getImage()
	 */
	public URL getImage() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::getImage");
		return image;
	}

	/*
	 * @see org.eclipse.higgins.idas.model.IDisplayData#getOrder()
	 */
	public int getOrder() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::getOrder");
		return order;
	}

	public String toString() {
		log.trace("org.eclipse.higgins.idas.model.impl.DisplayData::toString");
		StringBuffer sb = new StringBuffer("DD:");
		sb.append(" L=").append(label);
		sb.append(" D=").append(description);
		sb.append(" O=").append(order);
		sb.append(" I=").append(image);
		return sb.toString();
	}
}
