/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.cp.jena2;

import java.net.URI;
import java.util.List;
import java.util.Properties;

import org.w3c.dom.Element;

public interface IContextConfiguration {
	public String getCachePath();

	public URI getContextRef();

	public Properties getProperties();

	public void load(Properties defaults, Element e) throws Exception;

	public void store(Element e);

	public String getProperty(String key);

	public List getPropertyNames();

	public String getProperty(String key, String defaultValue);

}