/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.impl.Attribute;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Metadata;
import org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute;
import org.eclipse.higgins.idas.cp.jena2.util.HigginsVocabulary;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeModel;

public class Entity
implements IEntity {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$Entity == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Entity = Entity.class$("org.eclipse.higgins.idas.cp.jena2.impl.Entity")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Entity));
    protected Context context_ = null;
    protected IEntityModel model_ = null;
    protected Individual subject_ = null;
    protected OntClass ontClass_ = null;
    protected URI type_ = null;
    protected String userToken_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Entity;

    public Entity(Context context, Individual subject) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::Entity");
        if (context == null) {
            throw new IdASException("Couldn't create Entity with null IContext");
        }
        if (subject == null) {
            throw new IdASException("Couldn't create Entity for null subject individual");
        }
        this.context_ = context;
        this.subject_ = subject;
        this.ontClass_ = context.getOntClass(subject.getRDFType().getURI());
        URI type = this.getEntityType();
        this.model_ = this.context_.getContextModel().getEntityModel(type);
        if (this.model_ == null) {
            throw new IdASException("Can not get entity model for Entity URI " + type.toString());
        }
        this.userToken_ = ModelUtils.getUserToken(this.context_, this.subject_);
    }

    public IContext getContext() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getContext");
        return this.context_;
    }

    public IJenaContext getJenaContext() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getJenaContext");
        return this.context_;
    }

    public Individual getSubjectIndividual() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getSubjectIndividual");
        return this.subject_;
    }

    public IEntityModel getModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getModel");
        return this.model_;
    }

    public String getEntityID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getEntityID");
        IAttribute sAttr = this.getAttribute(HigginsVocabulary.uniqueIdentifierURI);
        if (sAttr == null) {
            throw new IdASException("Attributehttp://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier was not found");
        }
        IAttributeValue val = null;
        Iterator itr = sAttr.getValues();
        if (itr != null && itr.hasNext()) {
            val = (IAttributeValue)itr.next();
        }
        if (val == null) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier is null");
        }
        if (!val.isSimple()) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier is not SimpleValue");
        }
        Object data = ((ISimpleAttrValue)val).getData();
        if (data == null) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier contains null data");
        }
        return data.toString();
    }

    public URI getEntityType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getEntityType");
        if (this.type_ == null) {
            this.type_ = URI.create(this.ontClass_.getURI());
        }
        return this.type_;
    }

    public void remove() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::remove");
        this.context_.unregisterChangedSubject(this);
        ModelUtils.removeIndividual(this.context_, this.subject_);
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::addMetadata");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(metadataID);
        return newMetadata;
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::addMetadata");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(copyFrom.getMetaID());
        this.context_.registerChangedSubject(this);
        return newMetadata;
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getMetadata");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        String uri = metadataID.toString();
        DatatypeProperty prop = this.context_.getDatatypeProperty(uri);
        if (prop == null) {
            throw new IdASException("Can not find datatype property with URI " + uri);
        }
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleMetadata");
        }
        if (!ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)prop)) {
            throw new IdASException("Property with URI " + uri + " is not a subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleMetadata");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.ontClass_, (OntProperty)prop)) {
            throw new IdASException("Can not add metadata with type " + uri + " for class " + this.ontClass_.getURI());
        }
        return new Metadata(this.context_, this.subject_, prop, this);
    }

    public Iterator getMetadataSet() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getMetadataSet");
        ArrayList<Metadata> list = new ArrayList<Metadata>();
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleMetadata");
        }
        StmtIterator props = this.subject_.listProperties();
        while (props.hasNext()) {
            Statement st = props.nextStatement();
            Property prop = st.getPredicate();
            DatatypeProperty dpProperty = this.context_.getModel().getDatatypeProperty(prop.getURI());
            if (dpProperty == null || !ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)dpProperty)) continue;
            Metadata md = new Metadata(this.context_, this.subject_, dpProperty, this);
            list.add(md);
        }
        return list.iterator();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::addAttribute");
        return this.getAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::addAttribute");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IAttribute newAttr = this.getAttribute(copyFrom.getAttrID());
        this.context_.registerChangedSubject(this);
        Iterator itrVal = copyFrom.getValues();
        while (itrVal.hasNext()) {
            IAttributeValue value = (IAttributeValue)itrVal.next();
            newAttr.addValue(value);
        }
        Iterator itrMd = copyFrom.getMetadataSet();
        while (itrMd.hasNext()) {
            IMetadata metadata = (IMetadata)itrMd.next();
            newAttr.addMetadata(metadata);
        }
        return newAttr;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getAttribute");
        if (attrID == null) {
            throw new IdASException("Parameter \"attrID\" is null.");
        }
        String uri = attrID.toString();
        OntProperty op = this.context_.getOntProperty(uri);
        ObjectProperty attrProp = this.context_.getObjectProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#attribute");
        if (!ModelUtils.isPropertyRelative((OntProperty)attrProp, op)) {
            throw new InvalidTypeException("Property " + uri + " is not subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins#attribute");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.ontClass_, op)) {
            throw new InvalidTypeException("Can not create attribute with type " + uri + " for Entity with type " + this.ontClass_.getURI());
        }
        AttributeModel attrModel = (AttributeModel)this.model_.getAttributeModel(attrID);
        if (attrModel == null) {
            throw new IdASException("Can not get model of attribute with type " + uri + " for Entity with type " + this.ontClass_.getURI());
        }
        int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.ontClass_, op);
        if (maxCardinality == 1) {
            return new SingleValuedAttribute(this.context_, this, op, (IAttributeModel)attrModel);
        }
        return new Attribute(this.context_, this, op, (IAttributeModel)attrModel);
    }

    public Iterator getAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getAttributes");
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Iterator itr = this.model_.getAttributeModels();
        while (itr.hasNext()) {
            AttributeModel attrModel = (AttributeModel)itr.next();
            URI attrType = attrModel.getType();
            if (attrType == null) {
                throw new IdASException("Can not get the type of attribute model for Entity with type " + this.ontClass_.getURI());
            }
            ObjectProperty property = this.context_.getModel().getObjectProperty(attrType.toString());
            if (property == null) {
                throw new IdASException("Can not get object property with type " + attrType);
            }
            int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.ontClass_, (OntProperty)property);
            if (maxCardinality == 1) {
                attrs.add(new SingleValuedAttribute(this.context_, this, (OntProperty)property, (IAttributeModel)attrModel));
                continue;
            }
            attrs.add(new Attribute(this.context_, this, (OntProperty)property, (IAttributeModel)attrModel));
        }
        return attrs.iterator();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getSingleValuedAttribute");
        String idURI = attrID.toString();
        IAttribute attr = this.getAttribute(attrID);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof ISingleValuedAttribute)) {
            throw new IdASException("Attribute " + idURI + " is not an instance of ISingleValuedAttribute");
        }
        return (ISingleValuedAttribute)attr;
    }

    public String getUserToken() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getUserToken");
        return this.userToken_;
    }

    public boolean equals(Object obj) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::equals");
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity ds = (Entity)obj;
        return this.subject_.equals(ds.getSubjectIndividual());
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return false;
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return false;
    }

    public void removeAttribute(URI attrID) throws IdASException {
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

