/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.util.ConfigUtil;

public class JDBCContext
extends Context {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$JDBCContext == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$JDBCContext = JDBCContext.class$("org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext")) : class$org$eclipse$higgins$idas$cp$jena2$impl$JDBCContext));
    protected String dbURL_ = null;
    protected String dbUser_ = null;
    protected String dbPassword_ = null;
    protected String dbEngineName_ = null;
    protected String dbClass_ = null;
    protected IDBConnection conn_ = null;
    protected ModelMaker maker_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$JDBCContext;

    public JDBCContext() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::JDBCContext");
    }

    public JDBCContext(OntDocumentManager documentManager, IContextConfiguration config) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::JDBCContext(OntDocumentManager, IContextConfiguration)");
        this.initialize(config);
    }

    public JDBCContext(OntDocumentManager documentManager, IContextId contextID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::JDBCContext(OntDocumentManager, IContextId)");
        this.initialize(contextID);
    }

    public void initialize(IContextId contextID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::initialize(IContextId)");
        if (contextID == null) {
            throw new IdASException("Parameter \"contextID\" is null.");
        }
        Map config = contextID.getConfiguration();
        try {
            this.dbURL_ = (String)config.get("db.url");
            this.dbUser_ = (String)config.get("db.user");
            this.dbPassword_ = (String)config.get("db.password");
            this.dbEngineName_ = (String)config.get("db.engine");
            this.dbClass_ = (String)config.get("db.driver");
            this.ns_ = (String)config.get("context.uri");
            this.setSchemaURI((String)config.get("schema.url"), ConfigUtil.getFilePath((String)config.get("schema.file"), null));
            if (config.containsKey("validateSubjects")) {
                this.validateChangedSubjects_ = Boolean.valueOf((String)config.get("validateSubjects"));
            }
        }
        catch (ClassCastException e) {
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
    }

    private String getProp(Properties props, String propertyName) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::getProp");
        if (props == null) {
            throw new IdASException("Parameter props is null");
        }
        if (props.containsKey(propertyName)) {
            return props.get(propertyName).toString();
        }
        throw new IdASException("Property " + propertyName + " was not found");
    }

    public void init(Properties props) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::init");
        this.dbURL_ = this.getProp(props, "db.url");
        this.dbUser_ = this.getProp(props, "db.user");
        this.dbPassword_ = this.getProp(props, "db.password");
        this.dbEngineName_ = this.getProp(props, "db.engine");
        this.dbClass_ = this.getProp(props, "db.driver");
        this.schemaURL_ = this.getProp(props, "schema.url");
        this.schemaFileName_ = this.getProp(props, "schema.file");
        this.ns_ = this.getProp(props, "uri");
    }

    public void initialize(IContextConfiguration config) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::initialize");
        this.dbURL_ = config.getProperty("db.url");
        if (this.dbURL_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID() + " db.url=" + this.dbURL_);
        }
        this.dbUser_ = config.getProperty("db.user");
        if (this.dbUser_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID() + " db.user=" + this.dbUser_);
        }
        this.dbPassword_ = config.getProperty("db.password");
        if (this.dbPassword_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID() + " db.password=" + this.dbPassword_);
        }
        this.dbEngineName_ = config.getProperty("db.engine");
        if (this.dbEngineName_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID() + " db.engine=" + this.dbEngineName_);
        }
        this.dbClass_ = config.getProperty("db.driver");
        if (this.dbClass_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID() + " db.driver=" + this.dbClass_);
        }
        this.ns_ = config.getContextID().toString();
        if (this.ns_ == null) {
            throw new IdASException("Invalid context configuration: contextID=" + config.getContextID());
        }
        this.setSchemaURI(config.getProperty("schema.url"), ConfigUtil.getFilePath(config.getProperty("schema.file"), config.getCachePath()));
    }

    private OntModel getSchemaModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::getSchemaModel");
        InputStream schemaIS = null;
        File schemaFile = null;
        if (this.schemaFileName_ != null) {
            schemaFile = new File(this.schemaFileName_);
        }
        try {
            if (schemaFile != null && schemaFile.exists() && schemaFile.isFile()) {
                schemaIS = new FileInputStream(schemaFile);
            } else {
                URL schemaURL = new URL(this.schemaURL_);
                schemaIS = schemaURL.openStream();
            }
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            model.setDynamicImports(true);
            model.read(schemaIS, this.schemaURL_);
            return model;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
    }

    protected void init() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::init");
        try {
            Class.forName(this.dbClass_);
            this.conn_ = new DBConnection(this.dbURL_, this.dbUser_, this.dbPassword_, this.dbEngineName_);
            this.maker_ = ModelFactory.createModelRDBMaker((IDBConnection)this.conn_);
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
            spec.getDocumentManager().addAltEntry(this.schemaURL_, this.schemaFileName_);
            spec.setImportModelMaker(ModelFactory.createFileModelMaker((String)new File(this.schemaFileName_).getAbsolutePath()));
            Model base = null;
            if (this.maker_.hasModel(this.ns_)) {
                base = this.maker_.openModel(this.ns_);
                this.model_ = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)base);
            } else {
                base = this.maker_.createModel(this.ns_);
                this.model_ = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)base);
                this.model_.setDynamicImports(true);
                String schema = this.getSchemaURI();
                if (schema == null) {
                    throw new IdASException("Couldn't get schema URI");
                }
                this.model_.createOntology(schema);
                Resource imp = this.model_.createResource(schema);
                Property importProp = this.model_.getProperty("http://www.w3.org/2002/07/owl#imports");
                Ontology ont = this.model_.createOntology("");
                ont.addProperty(importProp, (RDFNode)imp);
                Model baseModel = this.model_.getBaseModel();
                baseModel.setNsPrefix("schema", this.schemaURL_);
                ExtendedIterator ei = this.model_.listImportedModels();
                while (ei.hasNext()) {
                    Model m = (Model)ei.next();
                    Map nsMap = m.getNsPrefixMap();
                    Iterator keys = nsMap.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        String value = (String)nsMap.get(key);
                        if (baseModel.getNsURIPrefix(value) != null) continue;
                        baseModel.setNsPrefix(key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                if (this.conn_ != null) {
                    this.conn_.close();
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
                throw new IdASException((Throwable)ex);
            }
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
    }

    protected void save() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::save");
        try {
            this.maker_.close();
            this.conn_.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
    }

    public void begin() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::begin");
        if (this.model_.supportsTransactions()) {
            try {
                this.model_.begin();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
        }
    }

    public void commit() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::commit");
        if (this.model_.supportsTransactions()) {
            try {
                this.model_.commit();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
        }
    }

    public boolean isTransactionSupported() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::isTransactionSupported");
        return this.model_.supportsTransactions();
    }

    public void rollback() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::rollback");
        if (this.model_.supportsTransactions()) {
            try {
                this.model_.abort();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
        } else {
            this.log.error((Object)"Can not rollback changes. Database does not support transactions.");
        }
    }

    public void cancelUpdates() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.JDBCContext::cancelUpdates");
        this.rollback();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

