/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.util;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.impl.Attribute;
import org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;
import org.eclipse.higgins.idas.cp.jena2.impl.Metadata;
import org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue;
import org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel;

public class ModelUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils == null ? (class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils = ModelUtils.class$("org.eclipse.higgins.idas.cp.jena2.util.ModelUtils")) : class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils));
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Metadata;

    public static boolean isClassRelative(OntClass ancestor, OntClass descendant) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isClassRelative");
        if (ancestor.equals(descendant)) {
            return true;
        }
        try {
            ExtendedIterator itr = descendant.listSuperClasses();
            while (itr.hasNext()) {
                OntClass cls = (OntClass)itr.next();
                if (!ModelUtils.isClassRelative(ancestor, cls)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    public static boolean isPropertyRelative(OntProperty ancestor, OntProperty descendant) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isPropertyRelative");
        try {
            for (OntProperty tmpDescendant = descendant; tmpDescendant != null; tmpDescendant = tmpDescendant.getSuperProperty()) {
                if (!tmpDescendant.hasSuperProperty((Property)ancestor, false)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    private static void fillListSuperClasses(List list, OntClass cls) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::fillListSuperClasses");
        if (cls != null && !cls.isRestriction()) {
            list.add(cls);
        }
        ExtendedIterator ei = cls.listSuperClasses();
        while (ei.hasNext()) {
            ModelUtils.fillListSuperClasses(list, (OntClass)ei.next());
        }
    }

    private static void fillListSubClasses(List list, OntClass cls) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::fillListSubClasses");
        if (cls != null && !cls.isRestriction()) {
            list.add(cls);
        }
        ExtendedIterator ei = cls.listSubClasses();
        while (ei.hasNext()) {
            ModelUtils.fillListSubClasses(list, (OntClass)ei.next());
        }
    }

    public static List getListSubClasses(Context context, OntClass ownerClass) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getListSubClasses");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSubClasses(classesList, ownerClass);
        return classesList;
    }

    public static List getListSuperClasses(IJenaContext context, OntClass ownerClass) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getListSuperClasses");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSuperClasses(classesList, ownerClass);
        return classesList;
    }

    public static boolean isPropertyOfClass(Context context, OntClass ownerClass, OntProperty property) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isPropertyOfClass");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSuperClasses(classesList, ownerClass);
        for (int i = 0; i < classesList.size(); ++i) {
            OntClass ontClass = (OntClass)classesList.get(i);
            ExtendedIterator ei = property.listDomain();
            while (ei.hasNext()) {
                Object node = ei.next();
                if (!(node instanceof OntClass)) continue;
                OntClass domain = (OntClass)node;
                if (!ontClass.getURI().equals(domain.getURI())) continue;
                return true;
            }
        }
        return false;
    }

    public static DatatypeProperty getSimpleValuePropertyByDomain(Context context, OntClass domainClass) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getSimpleValuePropertyByDomain");
        if (domainClass != null) {
            DatatypeProperty simpleValueProperty = context.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleValue");
            Property domain = context.getModel().getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
            StmtIterator ei = context.getModel().listStatements(null, domain, (RDFNode)domainClass);
            while (ei.hasNext()) {
                DatatypeProperty property = context.getDatatypeProperty(ei.nextStatement().getSubject().getURI());
                if (property == null || !ModelUtils.isPropertyRelative((OntProperty)simpleValueProperty, (OntProperty)property)) continue;
                return property;
            }
        }
        return null;
    }

    public static ArrayList getAttributePropertiesByDomain(IJenaContext context, OntClass domainClass) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getAttributePropertiesByDomain");
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        List subClasses = ModelUtils.getListSuperClasses(context, domainClass);
        OntProperty attributeProperty = context.getOntProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#attribute");
        Property domain = context.getModel().getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        for (int i = 0; i < subClasses.size(); ++i) {
            OntClass cls = (OntClass)subClasses.get(i);
            if (cls == null) continue;
            StmtIterator ei = context.getModel().listStatements(null, domain, (RDFNode)cls);
            while (ei.hasNext()) {
                OntProperty property = context.getModel().getOntProperty(ei.nextStatement().getSubject().getURI());
                if (property == null || !ModelUtils.isPropertyRelative(attributeProperty, property)) continue;
                list.add(property);
            }
        }
        return list;
    }

    public static Individual getSubjectByID(Context context, String cuid) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getSubjectByID");
        Individual digitalSubject = null;
        String queryString = "PREFIX  higgins: <http://www.eclipse.org/higgins/ontologies/2006/higgins#> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?ds \n WHERE { \n ?ds higgins:uniqueIdentifier ?a . \n ?a higgins:string  \"" + cuid + "\"^^xsd:string}";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)context.getModel());
        try {
            ResultSet results = qexec.execSelect();
            if (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode a = soln.get("ds");
                digitalSubject = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = ModelUtils.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        finally {
            qexec.close();
        }
        return digitalSubject;
    }

    public static OntClass getAttributeMetadataHolderClass(Context context, OntProperty attrProp) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getAttributeMetadataHolderClass");
        OntClass attributeClass = context.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins#Attribute");
        for (OntProperty curProp = attrProp; curProp != null; curProp = curProp.getSuperProperty()) {
            ExtendedIterator itr = curProp.listRange();
            while (itr.hasNext()) {
                OntClass dClass;
                Object node = itr.next();
                if (!(node instanceof OntClass) || !ModelUtils.isClassRelative(attributeClass, dClass = (OntClass)node)) continue;
                return dClass;
            }
        }
        throw new IdASException("Can not find attribute metadata holder class (subclass of http://www.eclipse.org/higgins/ontologies/2006/higgins#Attribute) for attribute property " + attrProp.getURI());
    }

    public static void removeIndividual(Context context, Individual ind) throws IdASException {
        Individual child;
        String type;
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::removeIndividual");
        String string = type = ind.getRDFType() != null ? ind.getRDFType().getURI() : null;
        if (type == null) {
            throw new IdASException("Indiividual doesn't have RDF type");
        }
        StmtIterator si = ind.listProperties();
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        ArrayList<Individual> individuals = new ArrayList<Individual>();
        while (si.hasNext()) {
            Statement st = si.nextStatement();
            RDFNode node = st.getObject();
            if (node.isLiteral()) {
                stmts.add(st);
                continue;
            }
            if (!node.isResource()) continue;
            child = null;
            try {
                child = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? ModelUtils.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            }
            catch (ClassCastException e) {
                throw new IdASException(e.getMessage());
            }
            if (child == null || type.equals(child.getURI())) continue;
            individuals.add(child);
        }
        Iterator itrStmt = stmts.iterator();
        while (itrStmt.hasNext()) {
            Statement st = (Statement)itrStmt.next();
            context.getModel().remove(st);
        }
        Iterator itrIndv = individuals.iterator();
        while (itrIndv.hasNext()) {
            child = (Individual)itrIndv.next();
            ModelUtils.removeIndividual(context, child);
        }
        ind.remove();
    }

    public static int getMaxCardinality(Context context, OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMaxCardinality");
        ExtendedIterator itr = cls.listSuperClasses();
        while (itr.hasNext()) {
            OntClass c = (OntClass)itr.next();
            if (c.isRestriction()) {
                Restriction r = c.asRestriction();
                if (!r.onProperty((Property)attr)) continue;
                if (r.isCardinalityRestriction()) {
                    CardinalityRestriction cr = r.asCardinalityRestriction();
                    return cr.getCardinality();
                }
                if (!r.isMaxCardinalityRestriction()) continue;
                MaxCardinalityRestriction cr = r.asMaxCardinalityRestriction();
                return cr.getMaxCardinality();
            }
            int res = ModelUtils.getMaxCardinality(context, c, attr);
            if (res == -1) continue;
            return res;
        }
        return -1;
    }

    public static int getMinCardinality(Context context, OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMinCardinality");
        ExtendedIterator itr = cls.listSuperClasses(true);
        while (itr.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)attr)) continue;
            if (r.isCardinalityRestriction()) {
                CardinalityRestriction cr = r.asCardinalityRestriction();
                return cr.getCardinality();
            }
            if (!r.isMinCardinalityRestriction()) continue;
            MinCardinalityRestriction cr = r.asMinCardinalityRestriction();
            return cr.getMinCardinality();
        }
        return -1;
    }

    public static void setUserToken(Context context, Individual subjectInd, String userToken) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::setUserToken");
        OntProperty tokenProp = context.getOntProperty("http://www.eclipse.org/higgins/authentication#userToken");
        if (userToken == null || userToken.length() == 0) {
            RDFNode node = subjectInd.getPropertyValue((Property)tokenProp);
            subjectInd.removeProperty((Property)tokenProp, node);
        } else {
            Literal ltr = context.getModel().createLiteral(userToken);
            subjectInd.setPropertyValue((Property)tokenProp, (RDFNode)ltr);
        }
    }

    public static String getUserToken(Context context, Individual subjectInd) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getUserToken");
        OntProperty tokenProp = context.getOntProperty("http://www.eclipse.org/higgins/authentication#userToken");
        RDFNode tokenNode = subjectInd.getPropertyValue((Property)tokenProp);
        if (tokenNode != null) {
            if (tokenNode.isLiteral()) {
                Literal ltr = (Literal)tokenNode.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = ModelUtils.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
                Object obj = ltr.getValue();
                if (obj != null) {
                    return obj.toString();
                }
            } else {
                throw new IdASException("Property http://www.eclipse.org/higgins/authentication#userToken contains non-literal value.");
            }
        }
        return null;
    }

    public static String generateUniqueID(Context context) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::generateUniqueID");
        String rnd = String.valueOf(Math.random()).substring(0);
        return String.valueOf(System.currentTimeMillis()) + rnd;
    }

    public static String getSimpleValuePropertyByXMLType(Context context, URI xmlDatatype) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getSimpleValuePropertyByXMLType");
        if (xmlDatatype == null) {
            return null;
        }
        String xmlType = xmlDatatype.toString();
        if (xmlType.startsWith("http://www.w3.org/2001/XMLSchema#")) {
            String higginsType = xmlType.replaceAll("http://www.w3.org/2001/XMLSchema#", "http://www.eclipse.org/higgins/ontologies/2006/higgins#");
            DatatypeProperty simpleValue = context.getModelNoException().getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleValue");
            DatatypeProperty dp = context.getModelNoException().getDatatypeProperty(higginsType);
            if (dp == null) {
                throw new IdASException("Can not find datatype property " + higginsType);
            }
            if (ModelUtils.isPropertyRelative((OntProperty)simpleValue, (OntProperty)dp)) {
                return higginsType;
            }
            throw new IdASException("Property \"" + higginsType + "\" is not subtype of property " + "http://www.eclipse.org/higgins/ontologies/2006/higgins#simpleValue");
        }
        throw new IdASException("Value \"" + xmlType + "\" is not an xml datatype property.");
    }

    public static void validateSubject(Context context, Entity subj) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateSubject");
        log.debug((Object)("ContextURI = " + context.getNS() + ", subject type = " + subj.getEntityType()));
        if (subj == null) {
            throw new IdASException("Parameter \"subj\" is null.");
        }
        Iterator attributeModels = null;
        IEntityModel subjModel = subj.getModel();
        if (subjModel != null) {
            attributeModels = subjModel.getAttributeModels();
        }
        Iterator itrAttr = subj.getAttributes();
        ModelUtils.validateAttributes(context, itrAttr, attributeModels);
        ModelUtils.validateMetadataSet(context, subj.getMetadataSet());
    }

    public static void validateAttributes(Context context, Iterator attributes, Iterator attributeModels) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateAttributes");
        ArrayList<String> attrIDs = new ArrayList<String>();
        while (attributes.hasNext()) {
            Object obj = attributes.next();
            if (!(obj instanceof Attribute)) {
                throw new IdASException("Instance of " + (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute = ModelUtils.class$("org.eclipse.higgins.idas.cp.jena2.impl.Attribute")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute).getName() + " expected, " + obj.getClass().getName() + " found.");
            }
            Attribute attr = (Attribute)obj;
            ModelUtils.validateAttribute(context, attr);
            attrIDs.add(attr.getAttrID().toString());
        }
    }

    public static boolean isFunctionalProperty(Context context, String attributeType) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isFunctionalProperty");
        ObjectProperty op = context.getObjectProperty(attributeType);
        return op != null && op.isFunctionalProperty();
    }

    public static void checkCardinality(Context context, Attribute attr, int realValuesCount) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::checkCardinality");
        URI attrIDURI = attr.getAttrID();
        if (attrIDURI == null) {
            throw new IdASException("Attribute type is null.");
        }
        String attrType = attrIDURI.toString();
        OntClass ontClass = attr.getOwnerClass();
        if (ontClass == null) {
            throw new IdASException("Can not get ownerClass for attribute with type " + attrType);
        }
        ExtendedIterator ei = ontClass.listSuperClasses(false);
        while (ei.hasNext()) {
            Restriction rs;
            String rsProperty;
            OntClass superClass = (OntClass)ei.next();
            if (!superClass.isRestriction() || !attrType.equals(rsProperty = (rs = superClass.asRestriction()).getOnProperty().getURI())) continue;
            try {
                MinCardinalityRestriction mcr;
                int expectedCount;
                if (rs.isCardinalityRestriction()) {
                    CardinalityRestriction cr = rs.asCardinalityRestriction();
                    expectedCount = cr.getCardinality();
                    if (expectedCount == realValuesCount) continue;
                    throw new IdASException("Wrong count (" + realValuesCount + ") of values for attribute with type " + attrType + ", expected count is " + expectedCount + ".");
                }
                if (rs.isMinCardinalityRestriction()) {
                    mcr = rs.asMinCardinalityRestriction();
                    expectedCount = mcr.getMinCardinality();
                    if (expectedCount <= realValuesCount) continue;
                    throw new IdASException("Wrong count (" + realValuesCount + ") of values for attribute with type " + attrType + ", expected count is more or equals " + expectedCount + ".");
                }
                if (!rs.isMaxCardinalityRestriction() || (expectedCount = (mcr = rs.asMaxCardinalityRestriction()).getMaxCardinality()) >= realValuesCount) continue;
                throw new IdASException("Wrong count (" + realValuesCount + ") of values for attribute with type " + attrType + ", expected count is less or equals " + expectedCount + ".");
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
        }
    }

    public static void validateAttribute(Context context, Attribute attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateAttribute");
        URI type = attr.getAttrID();
        if (type == null) {
            throw new IdASException("Type(ID) of attribute is null.");
        }
        String typeStr = type.toString();
        int valuesCount = 0;
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            ++valuesCount;
            Object obj = itr.next();
            if (obj instanceof SimpleValue) {
                boolean isFunctionalProperty = ModelUtils.isFunctionalProperty(context, typeStr);
                ModelUtils.validateSimpleValue(context, (SimpleValue)obj, isFunctionalProperty);
                continue;
            }
            if (obj instanceof ComplexValue) {
                ModelUtils.validateComplexValue(context, (ComplexValue)obj);
                continue;
            }
            if (obj == null) {
                throw new IdASException("Value of attribute is null.");
            }
            throw new IdASException("Unexpected class of value of attribute : " + obj.getClass().getName());
        }
        ModelUtils.checkCardinality(context, attr, valuesCount);
        ModelUtils.validateMetadataSet(context, attr.getMetadataSet());
    }

    public static void validateComplexValue(Context context, ComplexValue val) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateComplexValue");
        if (val != null) {
            Iterator attributeModels = null;
            AttributeComplexValueModel valueModel = val.getValueModel();
            if (valueModel != null) {
                attributeModels = valueModel.getAttributes();
            }
            Iterator itrAttr = val.getAttributes();
            ModelUtils.validateAttributes(context, itrAttr, attributeModels);
            ModelUtils.validateMetadataSet(context, val.getMetadataSet());
        }
    }

    public static void validateSimpleValue(Context context, SimpleValue val, boolean isFunctionalProperty) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateSimpleValue");
        ModelUtils.validateMetadataSet(context, val.getMetadataSet());
    }

    public static void validateMetadataSet(Context context, Iterator metadataSet) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateMetadataSet");
        while (metadataSet.hasNext()) {
            Object obj = metadataSet.next();
            if (!(obj instanceof Metadata)) {
                throw new IdASException("Instance of " + (class$org$eclipse$higgins$idas$cp$jena2$impl$Metadata == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Metadata = ModelUtils.class$("org.eclipse.higgins.idas.cp.jena2.impl.Metadata")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Metadata).getName() + " expected, " + obj.getClass().getName() + " found.");
            }
            Metadata metadata = (Metadata)obj;
            ModelUtils.validateMetadata(context, metadata);
        }
    }

    public static void validateMetadata(Context context, Metadata metadata) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateMetadata");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

