/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;

public class AttributeComplexValueModel
implements IAttributeComplexValueModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel == null ? (class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel = AttributeComplexValueModel.class$("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel")) : class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel));
    protected URI type = null;
    protected List attributes = null;
    protected Hashtable attMap = null;
    protected ContextModel ctx = null;
    protected OntClass att = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel;

    protected AttributeComplexValueModel(ContextModel ctx, OntClass att) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::AttributeComplexValueModel");
        if (ctx == null) {
            throw new IdASException("Parameter \"ctx\" is null.");
        }
        if (att == null) {
            throw new IdASException("Parameter \"att\" is null.");
        }
        this.ctx = ctx;
        this.att = att;
        this.initialize();
    }

    protected void initialize() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initialize");
        this.initType();
        this.initAttributes();
    }

    protected void initType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initType");
        if (this.type == null) {
            try {
                this.type = new URI(this.att.getURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                this.type = null;
            }
        }
    }

    protected void initAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initAttributes");
        this.log.debug((Object)("====== Init attributes of complex class " + this.att.getURI() + " ============================"));
        if (this.attributes == null) {
            this.attributes = new ArrayList();
            this.attMap = new Hashtable();
            ArrayList list = ModelUtils.getAttributePropertiesByDomain(this.ctx.getContext(), this.att);
            for (int i = 0; i < list.size(); ++i) {
                OntProperty op = (OntProperty)list.get(i);
                AttributeModel m = new AttributeModel(this.ctx, op, this.att);
                this.attributes.add(m);
                this.attMap.put(m.getType(), m);
                this.log.debug((Object)("Created attribute model for property " + op.getURI()));
            }
        }
    }

    public Iterator getAttributes() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getAttributes");
        if (this.attributes != null) {
            return this.attributes.iterator();
        }
        return null;
    }

    public boolean isSimple() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::isSimple");
        return false;
    }

    public URI getType() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getType");
        return this.type;
    }

    public IDisplayData getDisplayData() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getDisplayData");
        return null;
    }

    public IAttributeModel getAttribute(URI type) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getAttribute");
        if (type != null) {
            return (IAttributeModel)this.attMap.get(type);
        }
        return null;
    }

    public int getMaxCardinality() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMaxCardinality");
        return -1;
    }

    public IMetadataModel getMetadataModel(URI metadataID) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMetadataModel");
        return null;
    }

    public Iterator getMetadataModels() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMetadataModels");
        return null;
    }

    public int getMinCardinality() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMinCardinality");
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

