/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel;
import org.eclipse.higgins.idas.model.impl.DisplayData;
import org.eclipse.higgins.idas.model.impl.EntityModel;

public class ContextModel
implements IContextModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$ContextModel == null ? (class$org$eclipse$higgins$idas$model$impl$ContextModel = ContextModel.class$("org.eclipse.higgins.idas.model.impl.ContextModel")) : class$org$eclipse$higgins$idas$model$impl$ContextModel));
    private static boolean debug = true;
    private static String localBase = "c:\\Documents and Settings\\Val\\.higgins\\.ontology\\";
    public static final String IDAS_BASE_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#";
    public static final String C_DS_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#Entity";
    public static final String C_ATT_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#Value";
    public static final String C_SIMP_ATT_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#SimpleValue";
    public static final String C_COMP_ATT_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#ComplexValue";
    public static final String P_ATT_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#attribute";
    public static final String DD_BASE_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#";
    public static final String C_DD_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#DisplayData";
    public static final String P_DD_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#displayData";
    public static final String P_DD_LABEL_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#label";
    public static final String P_DD_DESC_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#description";
    public static final String P_DD_ORDER_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#order";
    public static final String P_DD_IMAGE_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#image";
    protected OntModel model = null;
    protected OntClass c_ds = null;
    protected OntClass c_val = null;
    protected OntClass c_simp_val = null;
    protected OntClass c_comp_val = null;
    protected ObjectProperty p_att = null;
    protected OntClass c_dd = null;
    protected AnnotationProperty p_dd = null;
    protected DatatypeProperty p_dd_label = null;
    protected DatatypeProperty p_dd_desc = null;
    protected DatatypeProperty p_dd_order = null;
    protected DatatypeProperty p_dd_image = null;
    protected OntClass c_cs = null;
    protected List attributes = null;
    protected List subjects = null;
    protected Hashtable subjectMap = null;
    protected URI type = null;
    protected IDisplayData displayData = null;
    protected boolean dd_init = false;
    protected IJenaContext context_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$ContextModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                IContextModel model = ContextModel.create(args[0]);
                System.out.println(model.getType());
                Iterator subjects = model.getEntityModels();
                if (subjects != null) {
                    while (subjects.hasNext()) {
                        ContextModel.showSubject((IEntityModel)subjects.next(), "");
                    }
                }
            }
            catch (IdASException e) {
                e.printStackTrace();
            }
        }
    }

    private static void showSubject(IEntityModel sm, String prefix) {
        System.out.println(prefix + "DS: " + sm.getType());
        ContextModel.showDisplayData(sm.getDisplayData(), prefix + "\t");
        Iterator attributes = sm.getAttributeModels();
        if (attributes != null) {
            while (attributes.hasNext()) {
                ContextModel.showAttribute((IAttributeModel)attributes.next(), prefix + "\t", true);
            }
        }
    }

    private static void showAttribute(IAttributeModel am, String prefix, boolean isAttributeOfSubjerct) {
        block6: {
            IAttributeValueModel v;
            block5: {
                if (isAttributeOfSubjerct) {
                    System.out.println(prefix + "ATTRIBUTE_OF_SUBJECT: " + am.getType());
                } else {
                    System.out.println(prefix + "ATT: " + am.getType());
                }
                ContextModel.showDisplayData(am.getDisplayData(), prefix + "\t");
                v = am.getValueModel();
                if (!v.isSimple()) break block5;
                AttributeSimpleValueModel sv = (AttributeSimpleValueModel)v;
                System.out.println(prefix + "VAL: " + sv.getType() + " isOneOf=" + sv.isOneOf());
                if (!sv.isOneOf()) break block6;
                List values = sv.getOneOf();
                for (int i = 0; i < values.size(); ++i) {
                    System.out.println(prefix + "\t" + i + ": " + values.get(i));
                }
                break block6;
            }
            IAttributeComplexValueModel cv = (IAttributeComplexValueModel)v;
            Iterator attrs = cv.getAttributes();
            if (attrs != null) {
                while (attrs.hasNext()) {
                    ContextModel.showAttribute((IAttributeModel)attrs.next(), prefix + "\t", false);
                }
            }
        }
    }

    private static void showDisplayData(IDisplayData dd, String prefix) {
        if (dd != null) {
            System.out.println(prefix + dd);
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        ContextModel.debug = debug;
    }

    public static String getLocalBase() {
        return localBase;
    }

    public static void setLocalBase(String localBase) {
        ContextModel.localBase = localBase;
    }

    public static IContextModel create(String schema) throws IdASException {
        URL url = null;
        try {
            File f = new File(schema);
            if (f.exists()) {
                URI uri = f.toURI();
                url = uri.toURL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (url == null) {
            try {
                url = new URL(schema);
            }
            catch (Exception e) {
                throw new IdASModelException("Can't find context's ontology model: " + schema, (Throwable)e);
            }
        }
        return ContextModel.create(url);
    }

    public static IContextModel create(IJenaContext context, OntModel model) throws IdASException {
        return new ContextModel(context, model);
    }

    public static IContextModel create(URL schema) throws IdASException {
        return new ContextModel(schema);
    }

    public static IContextModel create(InputStream schema) throws IdASException {
        return new ContextModel(schema);
    }

    private ContextModel(IJenaContext context, OntModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::ContextModel(IJenaContext, OntModel)");
        this.context_ = context;
        this.model = model;
        this.init();
    }

    private ContextModel(URL schema) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::ContextModel(URL)");
        try {
            OntDocumentManager mgr = OntDocumentManager.getInstance();
            File f = new File(mgr.doAltURLMapping(schema.toString()));
            if (f.exists()) {
                this.open(new FileInputStream(f));
            } else {
                this.open(schema.openStream());
            }
        }
        catch (IdASException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASModelException("Can't open context's ontology model: " + schema, (Throwable)e);
        }
    }

    private ContextModel(InputStream schema) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::ContextModel(InputStream)");
        this.open(schema);
    }

    private void open(InputStream is) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::open");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_TRANS_INF);
        this.model = ModelFactory.createOntologyModel((OntModelSpec)spec);
        this.model.read(is, null);
        this.init();
    }

    private void init() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::init");
        ValidityReport report = this.model.validate();
        if (report != null && !report.isValid()) {
            throw new IdASModelException("Context schema is not valid OWL DL ontology.");
        }
        this.c_ds = this.model.getOntClass(C_DS_URI);
        if (this.c_ds == null) {
            throw new IdASModelException("Invalid schema. Couldn't find class by URI http://www.eclipse.org/higgins/ontologies/2006/higgins#Entity");
        }
        this.p_att = this.model.getObjectProperty(P_ATT_URI);
        if (this.p_att == null) {
            throw new IdASModelException("Invalid schema. Couldn't find object property by URI http://www.eclipse.org/higgins/ontologies/2006/higgins#attribute");
        }
        this.c_val = this.model.getOntClass(C_ATT_URI);
        if (this.c_val == null) {
            throw new IdASModelException("Invalid schema. Couldn't find class by URI http://www.eclipse.org/higgins/ontologies/2006/higgins#Value");
        }
        this.c_simp_val = this.model.getOntClass(C_SIMP_ATT_URI);
        if (this.c_simp_val == null) {
            throw new IdASModelException("Invalid schema. Couldn't find class by URI http://www.eclipse.org/higgins/ontologies/2006/higgins#SimpleValue");
        }
        this.c_comp_val = this.model.getOntClass(C_COMP_ATT_URI);
        if (this.c_comp_val == null) {
            throw new IdASModelException("Invalid schema. Couldn't find class by URI http://www.eclipse.org/higgins/ontologies/2006/higgins#ComplexValue");
        }
        this.initType();
        this.initSubjects();
        this.initAttributes();
    }

    protected void initType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::initType");
        if (this.type == null) {
            Set impSet = this.model.listImportedOntologyURIs(true);
            ExtendedIterator itr = this.model.listOntologies();
            while (itr.hasNext()) {
                Ontology oo = (Ontology)itr.next();
                if (impSet.contains(oo.getURI())) continue;
                try {
                    this.type = new URI(oo.getURI());
                    itr.close();
                    break;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    this.type = null;
                }
            }
        }
        if (this.type == null) {
            throw new IdASModelException("Invalid context schema - can't initialize schema's URL");
        }
    }

    protected void initSubjects() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::initSubjects");
        if (this.subjects == null) {
            this.subjects = new ArrayList();
            this.subjectMap = new Hashtable();
            ExtendedIterator itr = this.model.listNamedClasses();
            while (itr.hasNext()) {
                OntClass c = (OntClass)itr.next();
                this.log.debug((Object)("Try to create SubjectModel for class " + c.getURI()));
                String ns = c.getNameSpace();
                if (!ns.startsWith(this.getType().toString()) || !ModelUtils.isClassRelative(this.c_ds, c)) continue;
                EntityModel dsm = new EntityModel(this, c);
                this.log.debug((Object)("Created SubjectModel for class " + c.getURI()));
                this.subjects.add(dsm);
                this.subjectMap.put(dsm.getType(), dsm);
            }
        }
    }

    protected void initAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::initAttributes");
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
    }

    protected void initDisplayData() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::initDisplayData");
        if (this.displayData == null && this.c_cs != null && this.getP_DD() != null && this.c_cs.hasProperty((Property)this.getP_DD())) {
            OntClass t;
            Individual in;
            Resource r;
            RDFNode n = this.c_cs.getPropertyValue((Property)this.getP_DD());
            System.out.println(n);
            if (n.canAs(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = ContextModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual) && (r = (in = (Individual)n.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = ContextModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual)).getRDFType()).canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = ContextModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass) && (t = (OntClass)r.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = ContextModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).equals(this.getC_DD())) {
                this.displayData = new DisplayData(this, in);
            }
        }
    }

    public IModel getModel(URI type) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getModel");
        return null;
    }

    public Iterator getAttributes() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getAttributes");
        if (this.attributes != null) {
            return this.attributes.iterator();
        }
        return null;
    }

    public Iterator getEntityModels() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getSubjectModels");
        if (this.subjects != null) {
            return this.subjects.iterator();
        }
        return null;
    }

    public IEntityModel getEntityModel(URI type) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getSubjectModel");
        if (type != null) {
            return (IEntityModel)this.subjectMap.get(type);
        }
        return null;
    }

    public URI getType() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getType");
        return this.type;
    }

    public IDisplayData getDisplayData() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getDisplayData");
        return this.displayData;
    }

    protected OntClass getC_VAL() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getC_VAL");
        return this.c_val;
    }

    protected OntClass getC_COMP_VAL() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getC_COMP_VAL");
        return this.c_comp_val;
    }

    protected OntClass getC_SIMP_VAL() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getC_SIMP_VAL");
        return this.c_simp_val;
    }

    protected ObjectProperty getP_ATT() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_ATT");
        return this.p_att;
    }

    protected OntClass getC_DS() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getC_DS");
        return this.c_ds;
    }

    protected OntModel getModel() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getModel");
        return this.model;
    }

    protected OntClass getC_DD() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getC_DD");
        return this.c_dd;
    }

    protected AnnotationProperty getP_DD() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_DD");
        return this.p_dd;
    }

    protected DatatypeProperty getP_DD_Desc() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_DD_Desc");
        return this.p_dd_desc;
    }

    protected DatatypeProperty getP_DD_Label() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_DD_Label");
        return this.p_dd_label;
    }

    protected DatatypeProperty getP_DD_Order() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_DD_Order");
        return this.p_dd_order;
    }

    protected DatatypeProperty getP_DD_Image() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getP_DD_Image");
        return this.p_dd_image;
    }

    protected IJenaContext getContext() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.ContextModel::getContext");
        return this.context_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

