/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.jena2.util.XMLDateConvertor;

public class XMLValueModel {
    private static Log staticLog = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$XMLValueModel == null ? (class$org$eclipse$higgins$idas$model$impl$XMLValueModel = XMLValueModel.class$("org.eclipse.higgins.idas.model.impl.XMLValueModel")) : class$org$eclipse$higgins$idas$model$impl$XMLValueModel));
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$XMLValueModel == null ? (class$org$eclipse$higgins$idas$model$impl$XMLValueModel = XMLValueModel.class$("org.eclipse.higgins.idas.model.impl.XMLValueModel")) : class$org$eclipse$higgins$idas$model$impl$XMLValueModel));
    protected URI type = null;
    protected boolean isOneOf = false;
    protected List oneOf = null;
    protected OntProperty prop = null;
    protected XSDDatatype xsdType = null;
    protected static Hashtable typesMap = new Hashtable();
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$XMLValueModel;

    public static synchronized XMLValueModel getInstance(DatatypeProperty prop) throws IdASException {
        if (prop == null) {
            return null;
        }
        String uri = prop.getURI();
        if (typesMap.contains(uri)) {
            return (XMLValueModel)typesMap.get(uri);
        }
        XMLValueModel valueModel = new XMLValueModel((OntProperty)prop);
        typesMap.put(uri, valueModel);
        return valueModel;
    }

    protected XMLValueModel(OntProperty prop) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::XMLValueModel");
        this.prop = prop;
        this.initialize();
    }

    protected void initialize() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::initialize");
        this.oneOf = new ArrayList();
        OntResource r = this.prop.getRange();
        if (r != null) {
            if (r.isDataRange()) {
                DataRange dr = r.asDataRange();
                this.isOneOf = true;
                ExtendedIterator itr = dr.listOneOf();
                while (itr.hasNext()) {
                    Literal l = (Literal)itr.next();
                    RDFDatatype t = l.getDatatype();
                    this.initType(t.getURI());
                    this.oneOf.add(l.getValue());
                }
            } else {
                this.initType(r.getURI());
            }
        }
    }

    protected void initType(String typeUri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::initType");
        if (this.type == null) {
            try {
                this.xsdType = XMLValueModel.findXSDDatatype(typeUri);
                if (this.xsdType == null) {
                    throw new IdASModelException("Unsupported datatype of property's value: Property=" + this.prop.getURI() + " Datatype=" + typeUri);
                }
                this.type = new URI(typeUri);
            }
            catch (IdASException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IdASModelException("Invalid datatype of property's value: Property=" + this.prop.getURI() + " Datatype=" + typeUri, (Throwable)e);
            }
        } else if (!typeUri.equals(this.type)) {
            throw new IdASModelException("Datatype mismatch for enumerated values: Property=" + this.prop.getURI() + " Datatype1=" + this.type + " Datatype2=" + typeUri);
        }
    }

    public static XSDDatatype findXSDDatatype(String typeUri) {
        if (typeUri == null) {
            return null;
        }
        RDFDatatype rdfType = TypeMapper.getInstance().getTypeByName(typeUri);
        if (rdfType == null) {
            staticLog.warn((Object)("Couldn't find RDFDatatype by URI = " + typeUri));
            return null;
        }
        if (!(rdfType instanceof XSDDatatype)) {
            staticLog.warn((Object)("URI " + typeUri + " is not xsd datatype"));
            return null;
        }
        return (XSDDatatype)rdfType;
    }

    public static boolean isSupported(String typeUri) {
        return XMLValueModel.findXSDDatatype(typeUri) != null;
    }

    public boolean isOneOf() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::isOneOf");
        return this.isOneOf;
    }

    public List getOneOf() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::getOneOf");
        return this.oneOf;
    }

    public URI getType() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::getType");
        return this.type;
    }

    public boolean isValidValue(Object valueForm) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::isValidValue");
        return this.xsdType.isValidValue(valueForm);
    }

    public boolean isValid(String lexicalForm) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::isValid");
        return this.xsdType.isValid(lexicalForm);
    }

    public Object toValueForm(String lexicalForm) throws IdASModelException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::toValueForm");
        if (lexicalForm == null) {
            return "";
        }
        try {
            return this.xsdType.parse(lexicalForm);
        }
        catch (Exception e) {
            throw new IdASModelException((Throwable)e);
        }
    }

    public Object toValueForm(Literal literal) throws IdASModelException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::toValueForm");
        if (literal != null) {
            Object obj = this.parse(literal);
            return obj;
        }
        return null;
    }

    public String toLexicalForm(Object value) throws IdASModelException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::toLexicalForm");
        if (value == null) {
            return null;
        }
        return this.unparseObj(value);
    }

    private String unparseObj(Object value) throws IdASModelException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::unparseObj");
        try {
            if (value instanceof Date) {
                return XMLDateConvertor.format((Date)value);
            }
            if (value instanceof byte[]) {
                return Base64.encode((byte[])((byte[])value));
            }
            if (value instanceof ByteBuffer) {
                return Base64.encode((byte[])((ByteBuffer)value).array());
            }
            return this.xsdType.unparse(value);
        }
        catch (Exception e) {
            throw new IdASModelException("Can not get lexical form for xml type " + this.type.toString() + ", object value " + value);
        }
    }

    private Object parse(Literal lt) throws IdASModelException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::parse");
        try {
            if (this.type.equals(ITypedValue.DATE_TYPE_URI) || this.type.equals(ITypedValue.DATETIME_TYPE_URI) || this.type.equals(ITypedValue.DATETIME_TYPE_URI) || this.type.equals(ITypedValue.TIME_TYPE_URI)) {
                return XMLDateConvertor.parse(lt.getString());
            }
            if (this.type.equals(ITypedValue.ANYURI_TYPE_URI)) {
                try {
                    return new URI(lt.getString());
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new IdASModelException((Throwable)e);
                }
            }
            if (this.type.equals(ITypedValue.BASE64BINARY_TYPE_URI)) {
                byte[] bytes = null;
                try {
                    bytes = (byte[])lt.getValue();
                    ByteBuffer bb = ByteBuffer.allocate(bytes.length);
                    bb.put(bytes);
                    return bb;
                }
                catch (ClassCastException e) {
                    this.log.error((Object)e);
                    throw new IdASException((Throwable)e);
                }
            }
            return lt.getValue();
        }
        catch (Exception e) {
            throw new IdASModelException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

