/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.model.impl.XMLValueModel;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class XMLValue {
	private Log log = LogFactory.getLog(XMLValue.class);

	protected Individual valueContainer_ = null;

	protected DatatypeProperty property_ = null;

	protected XMLValueModel model_ = null;

	protected IJenaContext context_ = null;

	protected URI type_ = null;

	public XMLValue(IJenaContext context, Individual valueContainer, DatatypeProperty property) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::XMLValue");
		if (context == null)
			throw new IdASException("Parameter \"context\" is null.");
		if (valueContainer == null)
			throw new IdASException("Parameter \"valueContainer\" is null.");
		if (property == null)
			throw new IdASException("Parameter \"property\" is null.");
		context_ = context;
		valueContainer_ = valueContainer;
		property_ = property;
		model_ = XMLValueModel.getInstance(property_);
	}

	public String getCanonical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getCanonical");
		return getLexical();
	}

	public Object getData() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getData");
		RDFNode node = valueContainer_.getPropertyValue(property_);
		if (node != null && node.isLiteral()) {
			Literal lt = (Literal) node.as(Literal.class);
			return model_.toValueForm(lt);
		} else
			return null;
	}

	public String getLexical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getLexical");
		Object data = getData();
		return data != null ? model_.toLexicalForm(data) : null;
	}

	public void setData(Object data) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::setData");
		if (data != null) {
			String lexicalForm = model_.toLexicalForm(data);
			Literal literal = context_.getModel().createTypedLiteral(lexicalForm, model_.getType().toString());
			valueContainer_.setPropertyValue(property_, literal);
		} else {
			RDFNode node = valueContainer_.getPropertyValue(property_);
			if (node != null)
				valueContainer_.removeProperty(property_, node);
		}
	}

	public URI getOwlType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getOwlType");
		if (type_ == null)
			type_ = URI.create(property_.getURI());
		return type_;
	}

	public URI getXmlType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getXmlType");
		return model_.getType();
	}

	public void remove() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::remove");
		RDFNode node = valueContainer_.getPropertyValue(property_);
		if (node != null)
			valueContainer_.removeProperty(property_, node);
	}

}
