/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeNode implements INode {
	private Log log = LogFactory.getLog(TypeNode.class);

	private int index_ = -1;

	public static String type_ = "type";

	public String getType() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeNode::getType");
		return type_;
	}

	public boolean hasIndex() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeNode::hasIndex");
		if (index_ > -1)
			return true;
		else
			return false;
	}

	public boolean indexRequired() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeNode::indexRequired");
		return true;
	}

	public void setIndex(int i) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeNode::setIndex");
		if (i > -1)
			index_ = i;
	}

	public String asQueryElement() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeNode::asQueryElement");
		return "?" + type_ + index_;
	}

}