/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IComplexMetaValue;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IMetadataValue;
import org.eclipse.higgins.idas.api.ISimpleMetaValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IMetadataModel;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;

public class Metadata implements IMetadata {
	private Log log = LogFactory.getLog(Metadata.class);

	// the subject which owns this metadata (directly or through any level of attribute/value)
	protected Entity subject_ = null;

	protected XMLValue value_ = null;

	protected Context context_ = null;

	public Metadata(Context context, Individual valueContainer, DatatypeProperty property, Entity subjOwner) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::Metadata");
		if (subjOwner == null)
			throw new IdASException("Parameter \"subjOwner\" is null.");
		subject_ = subjOwner;
		context_ = context;
		value_ = new XMLValue(context, valueContainer, property);
	}

	public String getCanonical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getCanonical");
		return value_.getCanonical();
	}

	public Object getData() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getData");
		return value_.getData();
	}

	public URI getMetaID() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getMetadataType");
		return value_.getOwlType();
	}

	public String getLexical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getLexical");
		return value_.getLexical();
	}

	public IMetadataModel getModel() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getModel");
		return null;
	}

	public URI getDataType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::getType");
		return value_.getXmlType();
	}

	public void remove() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::remove");
		context_.registerChangedSubject(subject_);
		value_.remove();
	}

	public void setData(Object data) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.Metadata::setData");
		value_.setData(data);
		context_.registerChangedSubject(subject_);
	}

	public IComplexMetaValue addComplexValue(URI dataType)
			throws IdASException, InvalidTypeException {
		// TODO Auto-generated method stub
		return null;
	}

	public ISimpleMetaValue addSimpleValue(URI dataType, Object data)
			throws IdASException, InvalidTypeException {
		// TODO Auto-generated method stub
		return null;
	}

	public IMetadataValue addValue(URI dataType) throws IdASException,
			InvalidTypeException {
		// TODO Auto-generated method stub
		return null;
	}

	public IMetadataValue addValue(IMetadataValue copyFrom)
			throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean equals(IMetadata meta) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

	public Iterator getValues() throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isSingleValued() throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

}
