/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.util.HigginsVocabulary;

public class FilterEntityIDAssertion extends FilterAssertion implements IFilterEntityIDAssertion {
	private Log log = LogFactory.getLog(FilterEntityIDAssertion.class);

	private String subjID_ = null;

	private FilterAttributeAssertion assertion_ = null;

	private Context idasContext_ = null;

	/**
	 * @param idasContext
	 */
	public FilterEntityIDAssertion(Context idasContext) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::FilterEntityIDAssertion");
		idasContext_ = idasContext;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterEntityIDAssertion#setAssertionValue(java.lang.String)
	 */
	public void setAssertionValue(String subjID) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::setAssertionValue");
		if (subjID == null)
			throw new IdASException("Unable to set \"null\" assertion value");
		subjID_ = subjID;
	}

	/**
	 * @return
	 * @throws IdASException
	 */
	public String getAssertionValue() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::getAssertionValue");
		return subjID_;
	}

	/**
	 * @return
	 * @throws IdASException
	 */
	public FilterAttributeAssertion getAttributeAssertion() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::getAttributeAssertion");
		if (subjID_ == null)
			throw new IdASException("FilterEntityIDAssertion contains \"null\" assertion value");
		if (assertion_ == null) {
			assertion_ = new FilterAttributeAssertion(idasContext_);
			assertion_.setComparator(IFilterAttributeAssertion.COMP_ATTR_EQ);
			assertion_.setID(URI.create(HigginsVocabulary.uniqueIdentifier));
		}
		assertion_.setAssertionValue(idasContext_.buildSimpleAttrValue(ISimpleAttrValue.NORMALIZEDSTRING_TYPE_URI, subjID_));
		assertion_.includeSubtypes(includeSubtypes_);
		assertion_.setComparator(comparator_);
		return assertion_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#setID(java.net.URI)
	 */
	public void setID(URI id) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::setID");
		throw new IdASException("The type of FilterEntityIDAssertion is predefined and couldn't be changed.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#getCondition()
	 */
	public ICondition getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::getCondition");
		return assertion_.getCondition();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#init(org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext)
	 */
	public void init(FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion::init");
		assertion_.init(filterContext);
	}

}
