/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterMetadataAssertion;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;

import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FilterMetadataAssertion extends FilterAssertion implements IFilterMetadataAssertion {
	private Log log = LogFactory.getLog(FilterMetadataAssertion.class);

	private IMetadata value_ = null;

	private GraphPattern attributePattern_ = null;

	private INode rootNode_ = null;

	private CompoundCondition condition_ = null;

	private Context idasContext_ = null;

	private FilterContext filterContext_ = null;

	public FilterMetadataAssertion(Context context) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::FilterMetadataAssertion");
		idasContext_ = context;
	}

/*	
	private void initWithComplexValue(CompoundCondition condition, PropertyNode propNode) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::initWithComplexValue");
		IComplexAttrValue val = (IComplexAttrValue)value_;
		GraphPattern pattern = filterContext_.registerPattern(new GraphPattern(rootNode_, propNode, new AttributeNode(), attributePattern_));
		//TODO add check of metadata value
		Iterable it = val.getProperties();
		if (it != null) {
			Iterator props = it.iterator();
			if (props != null) {
				while (props.hasNext()) {
					IProperty prop = (IProperty)props.next();
					Iterable<IPropertyValue> itv = prop.getValues();
					if (itv != null) {
						Iterator<IPropertyValue> vals = itv.iterator();
						if (vals != null) {
							while (vals.hasNext()) {
								IPropertyValue propVal = vals.next();
								PropertyNode xmlProp = new PropertyNode(propVal.getType().toString());
								GraphPattern pat = filterContext_.registerPattern(new GraphPattern(pattern.getObject(), xmlProp, new LiteralNode(), pattern));
								condition_.addCondition(new ValueCondition((LiteralNode) pat.getObject(), comparator_, propVal));

							}
						}
					}
					
				}
				
			}
		}
	}
*/
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#getCondition()
	 */
	public ICondition getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::getCondition");
		return condition_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#init(org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext)
	 */
	public void init(FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::init");
		initAsAttributeMetadata(null, filterContext);
	}

	/**
	 * @param rootPattern
	 * @param filterContext
	 * @throws IdASException
	 */
	public void initAsAttributeMetadata(GraphPattern rootPattern, FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::initAsAttributeMetadata");
		attributePattern_ = rootPattern;
		filterContext_ = filterContext;
		rootNode_ = attributePattern_ == null ? filterContext_.getSubjectNode() : attributePattern_.getObject();
		if (idasContext_ == null)
			throw new IdASException("Can't init FilterMetadataAssertion because context is null.");
		if (value_ == null)
			throw new IdASException("Can't init FilterMetadataAssertion because value is null.");
		if (type_ == null)
			throw new IdASException("Can't init FilterMetadataAssertion because type is null.");
		if (comparator_ == null)
			throw new IdASException("Can't init FilterMetadataAssertion because comparator is null.");
		String type = type_.toString();
		condition_ = new CompoundCondition(Filter.OP_OR);
		ArrayList types = new ArrayList();
		types.add(type);
		if (includeSubtypes_) {
			OntProperty prop = idasContext_.getOntProperty(type);
			ExtendedIterator it = prop.listSubProperties();
			while (it.hasNext()) {
				OntProperty subProp = (OntProperty)it.next();
				types.add(subProp.getURI());
			}
		}
		int typesCount = types.size();
		for (int i = 0; i < typesCount; i++) {
			String subType = (String)types.get(i);
			CompoundCondition condition = new CompoundCondition(Filter.OP_AND);
			condition_.addCondition(condition);
			PropertyNode propNode = new PropertyNode(subType);
			GraphPattern pattern = filterContext_.registerPattern(new GraphPattern(rootNode_, propNode, new LiteralNode(), attributePattern_));

//TODO implement addCondition for metadata			
//			condition.addCondition(new ValueCondition((LiteralNode) pattern.getObject(), comparator_, value_.getValues()));

		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IFilterMetadataAssertion#setAssertionValue(org.eclipse.higgins.idas.api.IMetadata)
	 */
	public void setAssertionValue(IMetadata assertion) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterMetadataAssertion::setAssertionValue");
		value_ = assertion;
	}

}
