/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubjectNode implements INode {
	private Log log = LogFactory.getLog(SubjectNode.class);

	public static final String SUBJ_NODE = "subj";

	public String getType() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode::getType");
		return SUBJ_NODE;
	}

	public boolean hasIndex() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode::hasIndex");
		return false;
	}

	public boolean indexRequired() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode::indexRequired");
		return false;
	}

	public void setIndex(int i) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode::setIndex");
	}

	public String asQueryElement() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode::asQueryElement");
		return "?" + SUBJ_NODE;
	}

}
