/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntClass;

public class AttributeSimpleValueModel implements IAttributeSimpleValueModel {
	private Log log = LogFactory.getLog(AttributeSimpleValueModel.class);

	protected URI type = null;

	protected ContextModel ctx = null;

	protected OntClass att = null;

	protected DatatypeProperty property_ = null;

	protected XMLValueModel xmlValue_ = null;

	protected AttributeSimpleValueModel(ContextModel ctx, OntClass att) throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::AttributeSimpleValueModel");
		if (ctx == null)
			throw new IdASException("Parameter \"ctx\" is null.");
		if (att == null)
			throw new IdASException("Parameter \"att\" is null.");
		this.ctx = ctx;
		this.att = att;
		initialize();
	}

	protected void initialize() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::initialize");
		initType();
		initXMLValue();
	}

	protected void initType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::initType");
		if (type == null) {
			try {
				type = new URI(att.getURI());
			} catch (URISyntaxException e) {
				e.printStackTrace();
				type = null;
			}
		}
	}

	protected void initXMLValue() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::initXMLValue");
		//TODO uncoment line below
		//		property_ = getSimpleValuePropertyByDomain(ctx.get, att);
		xmlValue_ = XMLValueModel.getInstance(property_);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.ISimpleValueModel#getMaxCardinality()
	 */
	public int getMaxCardinality() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getMaxCardinality");
		//TODO need to implement this method
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.ISimpleValueModel#getMinCardinality()
	 */
	public int getMinCardinality() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getMinCardinality");
		//TODO need to implement this method
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IAttributeValueModel#isSimple()
	 */
	public boolean isSimple() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::isSimple");
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IModel#getType()
	 */
	public URI getType() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getType");
		return type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IModel#getDisplayData()
	 */
	public IDisplayData getDisplayData() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getDisplayData");
		//TODO implement this method
		return null;
	}

	public IAttributeModel getAttribute() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getAttribute");
		// TODO remove this method from interface
		return null;
	}

	public IAttributeValueModel getValue() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getValue");
		// TODO remove this method from interface
		return null;
	}

	public List getOneOf() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getOneOf");
		return xmlValue_.getOneOf();
	}

	public boolean isOneOf() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::isOneOf");
		return xmlValue_.isOneOf;
	}

	public boolean isValid(String lexicalForm) {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::isValid");
		return xmlValue_.isValid(lexicalForm);
	}

	public boolean isValidValue(Object valueForm) {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::isValidValue");
		return xmlValue_.isValidValue(valueForm);
	}

	public String toLexicalForm(Object value) throws IdASModelException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::toLexicalForm");
		return xmlValue_.toLexicalForm(value);
	}

	public Object toValueForm(String lexicalForm) throws IdASModelException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::toValueForm");
		return xmlValue_.toValueForm(lexicalForm);
	}

	public IMetadataModel getMetadataModel(URI metadataID) {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getMetadataModel");
		// TODO Auto-generated method stub
		return null;
	}

	public Iterator getMetadataModels() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel::getMetadataModels");
		// TODO Auto-generated method stub
		return null;
	}

}
