package org.eclipse.higgins.idas.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

public class EntityModel implements IEntityModel {
	private Log log = LogFactory.getLog(EntityModel.class);

	protected ContextModel ctx = null;

	protected OntClass ds = null;

	protected URI type = null;

	protected List attributes = null;

	protected Hashtable attMap = null;

	protected IDisplayData displayData = null;

	protected EntityModel(ContextModel ctx, OntClass ds) throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::EntityModel");
		this.ctx = ctx;
		this.ds = ds;
		initialize();
	}

	protected void initialize() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::initialize");
		initType();
		initAttributes();
		initDisplayData();
	}

	protected void initType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::initType");
		if (type == null) {
			try {
				type = new URI(ds.getURI());
			} catch (URISyntaxException e) {
				throw new IdASModelException(e);
			}
		}
	}

	protected void initAttributes() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::initAttributes");
		log.debug("====== Init attributes of subject " + ds.getURI() + " ============================");
		if (attributes == null) {
			attributes = new ArrayList();
			attMap = new Hashtable();
			ArrayList list = ModelUtils.getAttributePropertiesByDomain(ctx.getContext(), ds);
			for (int i = 0; i < list.size(); i++) {
				OntProperty op = (OntProperty) list.get(i);
				IAttributeModel m = new AttributeModel(ctx, op, ds);
				attributes.add(m);
				attMap.put(m.getType(), m);
				log.debug("Created attribute model for property " + op.getURI());
			}
		}
	}

	protected void initDisplayData() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::initDisplayData");
		if (displayData == null) {
			if (ctx.getP_DD() != null && ds.hasProperty(ctx.getP_DD())) {
				RDFNode n = ds.getPropertyValue(ctx.getP_DD());
				if (n.canAs(Individual.class)) {
					Individual in = (Individual) n.as(Individual.class);
					Resource r = in.getRDFType();
					if (r.canAs(OntClass.class)) {
						OntClass t = (OntClass) r.as(OntClass.class);
						if (t.equals(ctx.getC_DD())) {
							displayData = new DisplayData(ctx, in);
						}
					}
				}
			}
		}
	}

	public Iterator getAttributeModels() {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getAttributeModels");
		return attributes.iterator();
	}

	public URI getType() {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getType");
		return type;
	}

	public IDisplayData getDisplayData() {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getDisplayData");
		return displayData;
	}

	public IAttributeModel getAttributeModel(URI type) {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getAttributeModel");
		return (IAttributeModel) attMap.get(type);
	}

	public IMetadataModel getMetadataModel(URI metadataID) {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getMetadataModel");
		return null;
	}

	public Iterator getMetadataModels() {
		log.trace("org.eclipse.higgins.idas.model.impl.EntityModel::getMetadataModels");
		return null;
	}

}
