/**
 * Copyright (c) 2006 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2;

import java.util.Properties;

import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;

public interface IJenaContext extends IContext {
	/**
	 * return jena ontology model of the context
	 * 
	 * @throws IdASException
	 *             If the context is not open or its ontology model is not
	 *             initialized
	 */
	public OntModel getModel() throws IdASException;

	/**
	 * return namespace of context
	 */
	public String getNS();

	/**
	 * @param uri
	 * @return
	 * @throws IdASException
	 */
	public DatatypeProperty getDatatypeProperty(String uri) throws IdASException;

	/**
	 * @param uri
	 * @return
	 * @throws IdASException
	 */
	public ObjectProperty getObjectProperty(String uri) throws IdASException;

	/**
	 * @param uri
	 * @return
	 * @throws IdASException
	 */
	public OntProperty getOntProperty(String uri) throws IdASException;

	/**
	 * @param uri
	 * @return
	 * @throws IdASException
	 */
	public OntClass getOntClass(String uri) throws IdASException;

	/**
	 * @param props
	 * @throws IdASException
	 */
	public void init(Properties props) throws IdASException;

	/*
	 * temporary commented
	 * 
	 * public void initialize(IContextConfiguration config) throws
	 * IdASException;
	 * 
	 * 
	 */

	/**
	 * @throws IdASException
	 */
	public void begin() throws IdASException;

	/**
	 * @throws IdASException
	 */
	public void commit() throws IdASException;

	/**
	 * @throws IdASException
	 */
	public void rollback() throws IdASException;

	/**
	 * @return
	 * @throws IdASException
	 */
	public boolean isTransactionSupported() throws IdASException;

	/**
	 * @return schema URI that will be used as imported ontology
	 * @throws IdASException
	 */
	public String getSchemaURI() throws IdASException;

	/**
	 * When some Entity was changed (its attribute/value/metadata was added/removed/changed)
	 * it should be registered using this method to be validated before saving the context by .  
	 * @param subj
	 */
	public void registerChangedSubject(Entity subj);

	/**
	 *  When some Entity was removed it should be also removed from changed subjects list
	 *  to prevent validation of non-existent subject
	 * @param subj
	 */
	public void unregisterChangedSubject(Entity subj);

	/**
	 * @param performValidation if <code>true</code> then all changed subjects should be validated
	 * before saving of the context. Default value is <code>true</code>. In case of JDBC Context, if
	 * RDBMS does not support transactions, validation will not be performed 
	 */
	public void setValidationMode(boolean performValidation);
}
