/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntProperty;

public class SingleValuedAttribute extends Attribute implements ISingleValuedAttribute {
	private Log log = LogFactory.getLog(SingleValuedAttribute.class);

	protected SingleValuedAttribute(Context context, Entity subj, OntProperty property, IAttributeModel model) throws IdASException {
		super(context, subj, property, model);
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::SingleValuedAttribute");
	}

	protected SingleValuedAttribute(Context context, ComplexValue complexValue, OntProperty property, IAttributeModel model) throws IdASException {
		super(context, complexValue, property, model);
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::SingleValuedAttribute");
	}

	public IAttributeValue getValue() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::getValue");
		Iterator itr = getValues();
		if (itr.hasNext()) {
			IAttributeValue res = (IAttributeValue) itr.next();
			if (itr.hasNext() == false)
				return res;
			else
				throw new IdASException("SingleValuedAttribute with type " + getAttrID().toString() + " contains more than one value");
		} else
			return null;
	}

	public boolean isSingleValued() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::isSingleValued");
		return true;
	}

	public IComplexAttrValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::addComplexValue");
		if (isSimple_ == false) {
			context_.registerChangedSubject(subject_);
			IAttributeValue oldValue = getValue();
			if (oldValue == null) {
				Individual newValue = context_.getModel().createIndividual(valueClass_);
				owner_.setPropertyValue(property_, newValue);
				return new ComplexValue(context_, this, newValue, property_);
			} else {
				if (oldValue instanceof ComplexValue) {
					ComplexValue ov = (ComplexValue) oldValue;
					Individual ovContainer = ov.getValueIndividual();
					return new ComplexValue(context_, this, ovContainer, property_);
				} else
					throw new IdASException("Old value is not an instance of ComplexValue");
			}
		} else
			throw new IdASException("Can not create complex value for simple attribute with type " + getAttrID().toString());
	}

	public ISimpleAttrValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute::addSimpleValue");
		if (isSimple_ == true) {
			context_.registerChangedSubject(subject_);
			IAttributeValue oldValue = getValue();
			if (oldValue == null) {
				Individual newValue = context_.getModel().createIndividual(valueClass_);
				owner_.setPropertyValue(property_, newValue);
				SimpleValue sv = new SimpleValue(context_, this, newValue, property_);
				sv.setData(data);
				return sv;
			} else {
				if (oldValue instanceof SimpleValue) {
					SimpleValue ov = (SimpleValue) oldValue;
					Individual ovContainer = ov.getContainer();
					SimpleValue sv = new SimpleValue(context_, this, ovContainer, property_);
					sv.setData(data);
					return sv;
				} else
					throw new IdASException("Old value is not an instance of SimpleValue");
			}
		} else
			throw new IdASException("Can not create simple value for complex attribute with type " + getAttrID().toString());
	}

}
