/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;

public class AttributeComplexValueModel implements IAttributeComplexValueModel {
	private Log log = LogFactory.getLog(AttributeComplexValueModel.class);

	protected URI type = null;

	protected List attributes = null;

	protected Hashtable attMap = null;

	protected ContextModel ctx = null;

	protected OntClass att = null;

	protected AttributeComplexValueModel(ContextModel ctx, OntClass att) throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::AttributeComplexValueModel");
		if (ctx == null)
			throw new IdASException("Parameter \"ctx\" is null.");
		if (att == null)
			throw new IdASException("Parameter \"att\" is null.");
		this.ctx = ctx;
		this.att = att;
		initialize();
	}

	protected void initialize() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initialize");
		initType();
		initAttributes();
	}

	protected void initType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initType");
		if (type == null) {
			try {
				type = new URI(att.getURI());
			} catch (URISyntaxException e) {
				e.printStackTrace();
				type = null;
			}
		}
	}

	protected void initAttributes() throws IdASException {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::initAttributes");
		log.debug("====== Init attributes of complex class " + att.getURI() + " ============================");
		if (attributes == null) {
			attributes = new ArrayList();
			attMap = new Hashtable();
			ArrayList list =  ModelUtils.getAttributePropertiesByDomain(ctx.getContext(), att);
			for (int i = 0; i < list.size(); i++) {
				OntProperty op = (OntProperty)list.get(i);
				IAttributeModel m = new AttributeModel(ctx, op, att);
				attributes.add(m);
				attMap.put(m.getType(), m);
				log.debug("Created attribute model for property " + op.getURI());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IAttributeComplexValueModel#getAttributes()
	 */
	public Iterator getAttributes() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getAttributes");
		if (attributes != null)
			return attributes.iterator();
		else
			return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IAttributeValueModel#isSimple()
	 */
	public boolean isSimple() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::isSimple");
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IModel#getType()
	 */
	public URI getType() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getType");
		return type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IModel#getDisplayData()
	 */
	public IDisplayData getDisplayData() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getDisplayData");
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IAttributeComplexValueModel#getAttribute(URI
	 *      type)
	 */
	public IAttributeModel getAttribute(URI type) {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getAttribute");
		if (type != null)
			return (IAttributeModel) attMap.get(type);
		else
			return null;
	}

	public int getMaxCardinality() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMaxCardinality");
		return -1;
	}

	public IMetadataModel getMetadataModel(URI metadataID) {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMetadataModel");
		return null;
	}

	public Iterator getMetadataModels() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMetadataModels");
		return null;
	}

	public int getMinCardinality() {
		log.trace("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel::getMinCardinality");
		return -1;
	}

}
