/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.cp.jena2;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public interface IFactoryConfiguration {

	public Properties getDefaultProperties();

	public List getContextIDs();

	public String getCachePath();

	public IContextConfiguration getContextConfig(URI key);

	public void setContextConfig(IContextConfiguration config);

	public void addContextConfig(URI contextID, Properties p);

	public void removeContextConfig(URI contextID);

	public IContextConfiguration createContextConfig(URI contextID, Properties p);

	public void load(File config);

	public void save(File config);

}