/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.UnhandledExtensionException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.IUserAccount;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;
import org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.HigginsVocabulary;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicAuthNAttributesMaterials;
import org.eclipse.higgins.idas.spi.BasicComplexValue;
import org.eclipse.higgins.idas.spi.BasicSimpleValue;

public abstract class Context
implements IJenaContext {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$Context == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Context = Context.class$("org.eclipse.higgins.idas.cp.jena2.impl.Context")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Context));
    private Hashtable ontClasses_ = new Hashtable();
    private Hashtable ontProperties_ = new Hashtable();
    private Hashtable datatypeProperties_ = new Hashtable();
    private Hashtable objectProperties_ = new Hashtable();
    protected String ns_ = null;
    protected OntModel model_ = null;
    protected Individual contextObject_ = null;
    protected String schemaURL_ = null;
    protected String schemaFileName_ = null;
    protected IContextModel contextModel_ = null;
    protected Vector changedSubjects_ = new Vector();
    protected IUserAccount userAccount_ = null;
    protected Object previousCredentials_ = null;
    protected IExtension[] previousExtensions_ = null;
    protected AuthenticationModule authModule_ = null;
    protected boolean validateChangedSubjects_ = false;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Context;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter;

    protected abstract void init() throws IdASException;

    protected void save() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::save");
    }

    public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::addSubject");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        if (type == null) {
            throw new IdASException("Parameter \"type\" is null");
        }
        if (entityID != null && ModelUtils.getSubjectByID(this, entityID) != null) {
            throw new EntityExistsException("Subject with ID = " + entityID + " already exists");
        }
        String uri = type.toString();
        OntClass ontClass = this.getOntClass(uri);
        IEntityModel entityModel = this.contextModel_.getEntityModel(type);
        if (entityModel == null) {
            throw new IdASException("Context can not create entity with type " + uri);
        }
        Individual ind = this.model_.createIndividual((Resource)ontClass);
        String userToken = this.userAccount_.getUserToken();
        if (userToken != null && userToken.length() > 0) {
            ModelUtils.setUserToken(this, ind, userToken);
        }
        Entity subj = new Entity(this, ind, entityModel);
        String newSubjID = entityID != null ? entityID : ModelUtils.generateUniqueID(this);
        subj.getAttribute(HigginsVocabulary.entityIdURI).addSimpleValue(null, (Object)newSubjID);
        return subj;
    }

    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::addSubject");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null");
        }
        URI entityType = copyFrom.getEntityType();
        String uri = entityType.toString();
        IEntityModel entityModel = this.contextModel_.getEntityModel(entityType);
        if (entityModel == null) {
            throw new IdASException("Context can not create entity with type " + uri);
        }
        OntClass ontClass = this.getOntClass(uri);
        Individual ind = this.model_.createIndividual((Resource)ontClass);
        String userToken = this.userAccount_.getUserToken();
        if (userToken != null && userToken.length() > 0) {
            ModelUtils.setUserToken(this, ind, userToken);
        }
        Entity subj = new Entity(this, ind, entityModel);
        subj.getAttribute(HigginsVocabulary.entityIdURI).addSimpleValue(null, (Object)ModelUtils.generateUniqueID(this));
        Iterator attr = copyFrom.getAttributes();
        while (attr.hasNext()) {
            IAttribute attribute = (IAttribute)attr.next();
            if (HigginsVocabulary.entityIdURI.equals(attribute.getAttrID())) continue;
            subj.addAttribute(attribute);
        }
        this.registerChangedSubject(subj);
        return subj;
    }

    public IAttribute buildAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildAttribute");
        return new BasicAttribute(attrID, (Iterator)null, null, (IContext)this);
    }

    public IFilterAttributeAssertion buildAttributeAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildAttributeAssertion");
        return new FilterAttributeAssertion(this);
    }

    public IAuthNAttributesMaterials buildAuthNAttributesMaterials() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildAuthNAttributesMaterials");
        return new BasicAuthNAttributesMaterials(null, (IContext)this);
    }

    public IFilterEntityIDAssertion buildEntityIDAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildEntityIDAssertion");
        return new FilterEntityIDAssertion(this);
    }

    public IComplexAttrValue buildComplexAttrValue(URI type) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildComplexAttrValue");
        return new BasicComplexValue(type, null, null);
    }

    public IFilter buildFilter() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildFilter");
        return new Filter(this);
    }

    public ISimpleAttrValue buildSimpleAttrValue(URI type, Object value) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildSimpleAttrValue");
        return new BasicSimpleValue(type, value);
    }

    public IFilterEntityTypeAssertion buildEntityTypeAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::buildTypeAssertion");
        return new FilterTypeAssertion(this);
    }

    public void close() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::close");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        this.save();
        this.userAccount_ = null;
        this.ontClasses_.clear();
        this.ontProperties_.clear();
        this.datatypeProperties_.clear();
        this.objectProperties_.clear();
    }

    public String exportData(String filter, String representationFormat) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::exportData");
        throw new NotImplementedException("");
    }

    protected void setContextModel(ContextModel model) throws IdASException {
        this.contextModel_ = model;
    }

    public IContextModel getContextModel() throws IdASException {
        if (this.contextModel_ == null) {
            throw new IdASException("Can not initialize context model");
        }
        return this.contextModel_;
    }

    public void setContextModel(IContextModel model) throws IdASException {
        this.contextModel_ = model;
    }

    public URI getContextID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getContextID");
        try {
            return new URI(this.ns_);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
    }

    public String getSchema() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSchema");
        String res = null;
        OntModel schema = this.getModel().getImportedModel(this.schemaURL_);
        if (schema != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RDFWriter writer = schema.getBaseModel().getWriter("RDF/XML-ABBREV");
            writer.setProperty("xmlbase", (Object)this.ns_);
            writer.setProperty("allowBadURIs", (Object)"false");
            writer.write((Model)schema, (OutputStream)baos, this.ns_);
            res = baos.toString();
        }
        return res;
    }

    public IEntity getEntity(String cuid) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSubject");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        if (cuid == null) {
            throw new NoSuchEntityException("Couldn't get Entity with null cuid");
        }
        Individual subj = ModelUtils.getSubjectByID(this, cuid);
        if (subj == null) {
            throw new NoSuchEntityException("Couldn't find Entity with cuid : " + cuid);
        }
        if (this.hasUserPermissions(subj)) {
            URI entityTypeURI;
            String entityType = subj.getRDFType().getURI();
            try {
                entityTypeURI = new URI(entityType);
            }
            catch (URISyntaxException e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
            IEntityModel entityModel = this.contextModel_.getEntityModel(entityTypeURI);
            if (entityModel == null) {
                throw new IdASException("Context can not create entity with type " + entityType);
            }
            if (subj == null) {
                throw new NoSuchEntityException("Couldn't find Entity with cuid : " + cuid);
            }
            return new Entity(this, subj, entityModel);
        }
        throw new AuthenticationException("The user opened the context does not have permissions to the subject with ID = " + cuid + ".");
    }

    private boolean hasUserPermissions(Individual subj) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::hasUserPermissions");
        String userToken = this.userAccount_.getUserToken();
        if (userToken != null && userToken.length() > 0) {
            String realToken = ModelUtils.getUserToken(this, subj);
            return userToken.equals(realToken);
        }
        return true;
    }

    public IEntity getEntity(String cuid, Iterator attrSelectionList) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSubject");
        return this.getEntity(cuid);
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSubjects");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        Filter f = null;
        if (filter == null) {
            f = (Filter)this.buildFilter();
            FilterTypeAssertion fass = (FilterTypeAssertion)this.buildEntityTypeAssertion();
            fass.setID(HigginsVocabulary.EntityURI);
            fass.includeSubtypes(true);
            f.addFilter(fass);
        } else {
            if (!(filter instanceof Filter)) {
                throw new IdASException("IFIlter instance should be an instance of " + (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter = Context.class$("org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter")) : class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter).getName());
            }
            f = (Filter)filter;
        }
        FilterContext fc = new FilterContext(this, false);
        ArrayList<Entity> result = new ArrayList<Entity>();
        List lst = fc.getSubjectIndividuals(f);
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            URI entityTypeURI;
            Individual ind = (Individual)lst.get(i);
            String entityType = ind.getRDFType().getURI();
            try {
                entityTypeURI = new URI(entityType);
            }
            catch (URISyntaxException e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
            IEntityModel entityModel = this.contextModel_.getEntityModel(entityTypeURI);
            if (entityModel != null) {
                Entity ds = new Entity(this, ind, entityModel);
                result.add(ds);
                continue;
            }
            this.log.error((Object)("Context contains subject with unsupported type " + entityType));
        }
        return result.iterator();
    }

    public ArrayList getNodeIndividuals(IFilter filter, boolean ignoreUserToken) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSubjects");
        if (filter == null) {
            throw new IdASException("Parameter \"filter\" is null.");
        }
        if (!(filter instanceof Filter)) {
            throw new IdASException("IFIlter instance should be an instance of " + (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter = Context.class$("org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter")) : class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter).getName());
        }
        Filter f = (Filter)filter;
        FilterContext fc = new FilterContext(this, ignoreUserToken);
        ArrayList<Individual> result = new ArrayList<Individual>();
        List lst = fc.getSubjectIndividuals(f);
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            Individual ind = (Individual)lst.get(i);
            result.add(ind);
        }
        return result;
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSubjects");
        return this.getEntities(filter);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
        this.log.trace((Object)new Exception().getStackTrace()[0].getMethodName());
        if (extensions != null) {
            for (int index = 0; index < extensions.length; ++index) {
                if (!extensions[index].failIfUnsupported()) continue;
                throw new UnhandledExtensionException(extensions[index].getClass().getName() + " not supported");
            }
        }
        return this.getEntities(filter, attrSelectionList);
    }

    public void importData(String filter, String representationFormat) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::importData");
        throw new NotImplementedException("");
    }

    public boolean isOpen(Object identity) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::isOpen");
        if (identity == null) {
            return this.userAccount_ != null;
        }
        return identity.equals(this.previousCredentials_);
    }

    public String open(Object authentication, IExtension[] extensions) throws IdASException, ContextOpenException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::open");
        this.previousCredentials_ = null;
        this.previousExtensions_ = null;
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        if (extensions != null) {
            for (int index = 0; index < extensions.length; ++index) {
                if (!extensions[index].failIfUnsupported()) continue;
                throw new UnhandledExtensionException(extensions[index].getClass().getName() + " not supported");
            }
        }
        this.init();
        if (this.authModule_ == null) {
            this.authModule_ = new AuthenticationModule(this);
        }
        try {
            this.userAccount_ = this.authModule_.authenticate(authentication);
        }
        catch (Exception e) {
            try {
                this.model_.close();
            }
            catch (Exception ex) {
                this.log.error((Object)e, (Throwable)e);
            }
            throw new IdASException((Throwable)e);
        }
        this.previousExtensions_ = extensions;
        this.previousCredentials_ = authentication;
        return null;
    }

    public String open(Object authentication) throws IdASException, ContextOpenException {
        return this.open(authentication, null);
    }

    public void reopen() throws IdASException, AuthenticationException {
        if (this.previousCredentials_ == null) {
            throw new AuthenticationException("Previous authentication materials unavailable");
        }
        this.open(this.previousCredentials_, this.previousExtensions_);
    }

    public void removeSubject(String cuid) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::removeSubject");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        Individual subjInd = ModelUtils.getSubjectByID(this, cuid);
        if (subjInd == null) {
            throw new NoSuchEntityException("Couldn't find Entity with cuid : " + cuid);
        }
        ModelUtils.removeIndividual(this, subjInd);
    }

    public void setSchema(String schema) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::setSchema");
        this.schemaURL_ = schema;
    }

    public boolean verifyEntityAttributes(String subjectID, Iterator attributes) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::verifySubjectAttributes");
        throw new NotImplementedException("");
    }

    public OntModel getModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getModel");
        if (this.userAccount_ == null) {
            throw new ContextNotOpenException("");
        }
        if (this.model_ == null) {
            throw new IdASException("The context is open but its ontology model is not initialized");
        }
        return this.model_;
    }

    public OntModel getModelNoException() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getModelNoException");
        return this.model_;
    }

    public String getNS() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getNS");
        return this.ns_;
    }

    public IUserAccount getUserAccount() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getUserAccount");
        return this.userAccount_;
    }

    public DatatypeProperty getDatatypeProperty(String uri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getDatatypeProperty");
        if (uri == null) {
            throw new IdASException("Couldn't get DatatypeProperty for null URI");
        }
        if (this.datatypeProperties_.containsKey(uri)) {
            return (DatatypeProperty)this.datatypeProperties_.get(uri);
        }
        DatatypeProperty prop = this.getModel().getDatatypeProperty(uri);
        if (prop != null) {
            this.datatypeProperties_.put(uri, prop);
            return prop;
        }
        throw new IdASException("Couldn't find DatatypeProperty with URI : " + uri);
    }

    public ObjectProperty getObjectProperty(String uri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getObjectProperty");
        if (uri == null) {
            throw new IdASException("Couldn't get ObjectProperty for null URI");
        }
        if (this.objectProperties_.containsKey(uri)) {
            return (ObjectProperty)this.objectProperties_.get(uri);
        }
        ObjectProperty prop = this.getModel().getObjectProperty(uri);
        if (prop != null) {
            this.objectProperties_.put(uri, prop);
            return prop;
        }
        throw new IdASException("Couldn't find ObjectProperty with URI : " + uri);
    }

    public OntProperty getOntProperty(String uri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getOntProperty");
        if (uri == null) {
            throw new IdASException("Couldn't get OntProperty for null URI");
        }
        if (this.ontProperties_.containsKey(uri)) {
            return (OntProperty)this.ontProperties_.get(uri);
        }
        OntProperty prop = this.getModel().getOntProperty(uri);
        if (prop != null) {
            this.ontProperties_.put(uri, prop);
            return prop;
        }
        throw new IdASException("Couldn't find OntProperty with URI : " + uri);
    }

    public OntClass getOntClass(String uri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getOntClass");
        if (uri == null) {
            throw new IdASException("Couldn't get OntClass for null URI");
        }
        if (this.ontClasses_.containsKey(uri)) {
            return (OntClass)this.ontClasses_.get(uri);
        }
        OntClass cls = this.getModel().getOntClass(uri);
        if (cls != null) {
            this.ontClasses_.put(uri, cls);
            return cls;
        }
        throw new IdASException("Couldn't find OntClass with URI : " + uri);
    }

    public String getSchemaURI() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::getSchemaURI");
        return this.schemaURL_;
    }

    public void init(Properties props) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::init");
    }

    public void applyUpdates() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::applyUpdates");
        this.validateSubjects();
        this.commit();
    }

    private void validateSubjects() throws IdASException {
        if (!this.validateChangedSubjects_) {
            return;
        }
        int size = this.changedSubjects_.size();
        for (int i = 0; i < size; ++i) {
            Entity subj = (Entity)this.changedSubjects_.get(i);
            ModelUtils.validateSubject(this, subj);
        }
    }

    public void registerChangedSubject(Entity subj) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::registerChangedSubject");
        if (!this.validateChangedSubjects_) {
            return;
        }
        if (!this.changedSubjects_.contains(subj)) {
            this.changedSubjects_.add(subj);
        }
    }

    public void unregisterChangedSubject(Entity subj) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::unregisterChangedSubject");
        if (this.changedSubjects_.contains(subj)) {
            this.changedSubjects_.remove(subj);
        }
    }

    protected void setSchemaURI(String publicURI, String localSchemaFile) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Context::setSchemaURI");
        System.out.println("Context URI: \"" + this.getContextID() + "\", schema URI: public URI \"" + publicURI + "\", localFile \"" + localSchemaFile + "\"");
        this.schemaURL_ = publicURI;
        if (this.schemaURL_ == null) {
            throw new IdASException("Invalid context schema: url=" + this.schemaURL_);
        }
        this.schemaFileName_ = localSchemaFile;
        if (this.schemaFileName_ != null) {
            try {
                File f = new File(this.schemaFileName_);
                if (!f.exists()) {
                    URL u = new URL(this.schemaURL_);
                    BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
                    PrintWriter p = new PrintWriter(new FileOutputStream(f));
                    String s = null;
                    while ((s = r.readLine()) != null) {
                        p.println(s);
                    }
                    p.close();
                }
                if (f.exists()) {
                    OntDocumentManager dm = OntDocumentManager.getInstance();
                    dm.addAltEntry(this.schemaURL_, this.schemaFileName_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setValidationMode(boolean performValidation) {
        this.validateChangedSubjects_ = performValidation;
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return null;
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return null;
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return false;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return null;
    }

    public Iterator getAttributes() throws IdASException {
        return null;
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return null;
    }

    public void removeAttribute(URI attrID) throws IdASException {
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
    }

    public void setComponentSetting(String key, Object value, boolean failUnsupported) throws IdASException {
        if (failUnsupported) {
            throw new NotImplementedException("Setting type: " + key + "not implmented.");
        }
    }

    public void setComponentSetting(String key, Object value) throws IdASException {
        this.setComponentSetting(key, value, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

