/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel;
import org.eclipse.higgins.idas.model.impl.AttributeModel;
import org.eclipse.higgins.idas.model.impl.EntityModel;
import org.eclipse.higgins.idas.model.impl.HigginsVocabulary;

public class ContextModel
implements IContextModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$ContextModel == null ? (class$org$eclipse$higgins$idas$model$impl$ContextModel = ContextModel.class$("org.eclipse.higgins.idas.model.impl.ContextModel")) : class$org$eclipse$higgins$idas$model$impl$ContextModel));
    private List entityList_ = null;
    private HashMap entityMap_ = null;
    private OntModel model_ = null;
    private URI baseURI_ = null;
    private HashMap entityTree_ = null;
    private HashMap complexValueTree_ = null;
    private HashMap entityTypeByHBName_ = null;
    private AttributeModel ppidOwner_ = null;
    private HigginsVocabulary vocabulary_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$ContextModel;

    public ContextModel(OntModel model, URI baseURI) throws IdASException {
        this.model_ = model;
        this.baseURI_ = baseURI;
        this.vocabulary_ = new HigginsVocabulary(this.model_);
        try {
            this.init();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
    }

    private void init() throws Exception {
        this.complexValueTree_ = new HashMap();
        this.entityTree_ = new HashMap();
        this.initEntities();
    }

    private void initEntities() throws Exception {
        this.entityList_ = new ArrayList();
        this.entityMap_ = new HashMap();
        this.entityTypeByHBName_ = new HashMap();
        OntClass entityClass = this.vocabulary_.getEntity();
        if (entityClass == null) {
            throw new IdASException("Can not find class http://www.eclipse.org/higgins/ontologies/2008/6/higgins#Entity in model " + this.baseURI_);
        }
        this.addEntity(null, entityClass);
    }

    private void addEntity(EntityModel parent, OntClass enityClass) throws Exception {
        this.log.debug((Object)("Create EntityModel for class " + enityClass.getURI()));
        EntityModel em = new EntityModel(enityClass, parent, this);
        this.entityList_.add(em);
        this.entityMap_.put(enityClass.getURI(), em);
        this.registerEntity(em);
        this.entityTypeByHBName_.put(em.getId(), em.getType());
        ExtendedIterator itr = enityClass.listSubClasses();
        while (itr.hasNext()) {
            OntClass child = (OntClass)itr.next();
            this.addEntity(em, child);
        }
    }

    public IModel getModel(URI type) {
        if (type == null) {
            return null;
        }
        IEntityModel nm = this.getEntityModel(type);
        if (nm != null) {
            return nm;
        }
        int size = this.entityList_.size();
        for (int i = 0; i < size; ++i) {
            EntityModel entity = (EntityModel)this.entityList_.get(i);
            entity.getModel(type);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public IEntityModel getEntityModel(URI entityType) {
        if (entityType == null) {
            return null;
        }
        String str = entityType.toString();
        if (this.entityMap_.containsKey(str)) {
            return (EntityModel)this.entityMap_.get(str);
        }
        return null;
    }

    public Iterator getEntityModels() {
        return this.entityList_.iterator();
    }

    public URI getType() {
        return this.baseURI_;
    }

    public OntModel getOntModel() {
        return this.model_;
    }

    public void registerBlankEntityModel(AttributeComplexValueModel bn) {
        String parentType = bn.getParentType();
        ArrayList lst = null;
        if (this.complexValueTree_.containsKey(parentType)) {
            lst = (ArrayList)this.complexValueTree_.get(parentType);
        } else {
            lst = new ArrayList();
            this.complexValueTree_.put(parentType, lst);
        }
        boolean contains = false;
        URI type = bn.getType();
        int k = lst.size();
        for (int i = 0; i < k; ++i) {
            AttributeComplexValueModel v = (AttributeComplexValueModel)lst.get(i);
            if (type == null || !type.equals(v.getType())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            lst.add(bn);
        }
    }

    public void registerEntity(EntityModel nm) {
        String parentType = nm.getParentType();
        ArrayList lst = null;
        if (this.entityTree_.containsKey(parentType)) {
            lst = (ArrayList)this.entityTree_.get(parentType);
        } else {
            lst = new ArrayList();
            this.entityTree_.put(parentType, lst);
        }
        lst.add(nm);
    }

    public HashMap getEntitiesHash() {
        return this.entityTree_;
    }

    public HashMap getComplexValueHash() {
        return this.complexValueTree_;
    }

    public EntityModel getTopEntityModel() {
        return (EntityModel)this.getEntityModel(HigginsVocabulary.EntityURI);
    }

    public String getSchema() throws IdASException {
        String res = null;
        if (this.model_ != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RDFWriter writer = this.model_.getBaseModel().getWriter("RDF/XML-ABBREV");
            writer.setProperty("xmlbase", (Object)this.getType().toString());
            writer.setProperty("allowBadURIs", (Object)"false");
            writer.write((Model)this.model_, (OutputStream)baos, this.getType().toString());
            res = baos.toString();
        }
        return res;
    }

    public AttributeModel getPPIDAttribute() {
        return this.ppidOwner_;
    }

    public void setPPIDAttribute(AttributeModel ppidOwner) {
        this.ppidOwner_ = ppidOwner;
    }

    public HigginsVocabulary getHigginsVocabulary() {
        return this.vocabulary_;
    }

    public String getId() {
        return "context";
    }

    public IAttributeModel getAttributeModel(URI attrID) {
        return null;
    }

    public Iterator getAttributeModels() {
        return null;
    }

    public IDisplayData getDisplayData() throws IdASException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

