/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.model.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class ContextModelFactory {
	private static Log log = LogFactory.getLog(ContextModelFactory.class);

	private static HashMap models_ = new HashMap();

	public static IContextModel createContextModel(URI schemaURI, URL schemaURL) throws IdASModelException {
		if (schemaURI == null)
			throw new IdASModelException("Could not create context model. Parameter \"schemaURI\" is null.");
		if (schemaURL == null)
			throw new IdASModelException("Could not create context model. Parameter \"schemaURL\" is null.");
		if (models_.containsKey(schemaURI))
			return (IContextModel) models_.get(schemaURI);
		try {
			return createModel(schemaURI, schemaURL.openStream());
		} catch (IOException e) {
			log.error(e);
			throw new IdASModelException(e);
		}
	}

	private static synchronized IContextModel createModel(URI schemaURI, InputStream schemaStream) throws IdASModelException {
		try {
			OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
			model.read(schemaStream, schemaURI.toString());
			ContextModel cm = new ContextModel(model, schemaURI);
			models_.put(schemaURI, cm);
			return cm;
		} catch (Exception e) {
			log.error(e);
			throw new IdASModelException(e);
		}

	}

	public static IContextModel createContextModel(URI schemaURI, File file) throws IdASModelException {
		if (schemaURI == null)
			throw new IdASModelException("Could not create context model. Parameter \"schemaURI\" is null.");
		if (models_.containsKey(schemaURI))
			return (IContextModel) models_.get(schemaURI);
		try {
			URL url = new URL(schemaURI.toString());
			InputStream is = new FileInputStream(file);
			return createModel(schemaURI, is);
		} catch (Exception e) {
			log.error(e);
			throw new IdASModelException(e);
		}
	}

}
