/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.model.impl;

import java.net.URI;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;

/**
 * Vocabulary definitions from Higgins Ontology v1.20
 */
public class HigginsVocabulary {
	private ObjectProperty entityRelation_;

	private ObjectProperty entityCorrelation_;

	private ObjectProperty contextRelation_;

	private ObjectProperty contextCorrelation_;

	private DatatypeProperty contextId_;

	private DatatypeProperty entityId_;

	private AnnotationProperty accessControl_;

	private OntClass person_;

	private OntClass organization_;

	private OntClass group_;

	private OntClass entity_;

	private OntClass blankEntity_;

	private OntClass agent_;

	private Property rdfType_;

	public HigginsVocabulary(OntModel model) throws IdASException {
		init(model);
	}

	private void init(OntModel model) throws IdASModelException {
		try {
			entityRelation_ = model.getObjectProperty(entityRelation);
			entityCorrelation_ = model.getObjectProperty(entityCorrelation);
			contextRelation_ = model.getObjectProperty(contextRelation);
			contextCorrelation_ = model.getObjectProperty(contextCorrelation);
			contextId_ = model.getDatatypeProperty(contextId);
			entityId_ = model.getDatatypeProperty(entityId);
			accessControl_ = model.getAnnotationProperty(accessControl);
			person_ = model.getOntClass(Person);
			organization_ = model.getOntClass(Organization);
			group_ = model.getOntClass(Group);
			agent_ = model.getOntClass(Agent);
			entity_ = model.getOntClass(Entity);
			blankEntity_ = model.getOntClass(BlankEntity);
			rdfType_ = model.getProperty(HigginsVocabulary.RDF_TYPE);
		} catch (Exception e) {
			throw new IdASModelException(e);
		}
	}

	public static final String HIGGINS_BASE_RESOURCE_NAME = "org/eclipse/higgins/idas/cp/model/higgins.owl";

	public static final String HIGGINS_BASE = "http://www.eclipse.org/higgins/ontologies/2008/6/higgins";

	public static final String NAME_SPACE = HIGGINS_BASE + "#";

	public static final String Context = NAME_SPACE + "Context";

	public static final URI ContextURI = URI.create(Context);

	public static final String Entity = NAME_SPACE + "Entity";

	public static final URI EntityURI = URI.create(Entity);

	public static final String BlankEntity = NAME_SPACE + "BlankEntity";

	public static final URI BlankEntityURI = URI.create(Entity);

	public static final String Person = NAME_SPACE + "Person";

	public static final URI PersonURI = URI.create(Person);

	public static final String Organization = NAME_SPACE + "Organization";

	public static final URI OrganizationURI = URI.create(Organization);

	public static final String Group = NAME_SPACE + "Group";

	public static final URI GroupURI = URI.create(Group);

	public static final String Agent = NAME_SPACE + "Agent";

	public static final URI AgentURI = URI.create(Agent);

	public static final String entityRelation = NAME_SPACE + "entityRelation";

	public static final URI entityRelationURI = URI.create(entityRelation);

	public static final String contextRelation = NAME_SPACE + "contextRelation";

	public static final URI contextRelationURI = URI.create(contextRelation);

	public static final String entityId = NAME_SPACE + "entityId";

	public static final URI entityIdURI = URI.create(entityId);

	public static final String contextId = NAME_SPACE + "contextId";

	public static final URI contextIdURI = URI.create(contextId);

	public static final String entityCorrelation = NAME_SPACE + "entityCorrelation";

	public static final URI entityCorrelationURI = URI.create(entityCorrelation);

	public static final String comment = NAME_SPACE + "comment";

	public static final URI commentURI = URI.create(comment);

	public static final String contextCorrelation = NAME_SPACE + "contextCorrelation";

	public static final URI contextCorrelationURI = URI.create(contextCorrelation);

	public static final String accessControl = NAME_SPACE + "accessControl";

	public static final URI accessControlURI = URI.create(accessControl);

	/**
	 * RDF/OWL URIs
	 */

	public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema#";

	public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

	public static final String OWL11_onDataRange = "http://www.w3.org/2006/12/owl11#onDataRange";

	public static final String OWL11_pattern = "http://www.w3.org/2006/12/owl11#pattern";

	public static final String OWL11_length = "http://www.w3.org/2006/12/owl11#length";

	public static final String OWL11_minLength = "http://www.w3.org/2006/12/owl11#minLength";

	public static final String OWL11_maxLength = "http://www.w3.org/2006/12/owl11#maxLength";

	public static final String OWL11_minInclusive = "http://www.w3.org/2006/12/owl11#minInclusive";

	public static final String OWL11_maxInclusive = "http://www.w3.org/2006/12/owl11#maxInclusive";

	public static final String OWL11_minExclusive = "http://www.w3.org/2006/12/owl11#minExclusive";

	public static final String OWL11_maxExclusive = "http://www.w3.org/2006/12/owl11#";

	public static final String OWL11_totalDigits = "http://www.w3.org/2006/12/owl11#";

	public static final String OWL11_fractionDigits = "http://www.w3.org/2006/12/owl11#fractionDigits";

	public static final String OWL_Thing = "http://www.w3.org/2002/07/owl#Thing";

	/**
	 * Old (not used) Higgins URIs
	 */

	public static final String DisplayMetadata = NAME_SPACE + "DisplayMetadata";

	public static final URI DisplayMetadataURI = URI.create(DisplayMetadata);

	public static final String AttributeMetadata = NAME_SPACE + "AttributeMetadata";

	public static final URI AttributeMetadataURI = URI.create(AttributeMetadata);

	public static final String TimeSpan = NAME_SPACE + "TimeSpan";

	public static final URI TimeSpanURI = URI.create(TimeSpan);

	public static final String Statement = NAME_SPACE + "Statement";

	public static final URI StatementURI = URI.create(Statement);

	public static final String complexAttribute = NAME_SPACE + "complexAttribute";

	public static final URI complexAttributeURI = URI.create(complexAttribute);

	public static final String timeSpan = NAME_SPACE + "timeSpan";

	public static final URI timeSpanURI = URI.create(timeSpan);

	public static final String aboutAttribute = NAME_SPACE + "aboutAttribute";

	public static final URI aboutAttributeURI = URI.create(aboutAttribute);

	public static final String lastModified = NAME_SPACE + "lastModified";

	public static final URI lastModifiedURI = URI.create(lastModified);

	public static final String validTo = NAME_SPACE + "validTo";

	public static final URI validToURI = URI.create(validTo);

	public static final String syncConflict = NAME_SPACE + "syncConflict";

	public static final URI syncConflictURI = URI.create(syncConflict);

	public static final String description = NAME_SPACE + "description";

	public static final URI descriptionURI = URI.create(description);

	public static final String validFrom = NAME_SPACE + "validFrom";

	public static final URI validFromURI = URI.create(validFrom);

	public static final String order = NAME_SPACE + "order";

	public static final URI orderURI = URI.create(order);

	public static final String label = NAME_SPACE + "label";

	public static final URI labelURI = URI.create(label);

	public static final String simpleAttribute = NAME_SPACE + "simpleAttribute";

	public static final URI simpleAttributeURI = URI.create(simpleAttribute);

	public static final String creationTime = NAME_SPACE + "creationTime";

	public static final URI creationTimeURI = URI.create(creationTime);

	public static final String image = NAME_SPACE + "image";

	public static final URI imageURI = URI.create(image);

	public static final String lastVerifiedFromSource = NAME_SPACE + "lastVerifiedFromSource";

	public static final URI lastVerifiedFromSourceURI = URI.create(lastVerifiedFromSource);

	public static final String source = NAME_SPACE + "source";

	public static final URI sourceURI = URI.create(source);

	public static final String example = NAME_SPACE + "example";

	public static final URI exampleURI = URI.create(example);

	public static final String lastVerifyAttempt = NAME_SPACE + "lastVerifyAttempt";

	public static final URI lastVerifyAttemptURI = URI.create(lastVerifyAttempt);

	public static final String modBy = NAME_SPACE + "modBy";

	public static final URI modByURI = URI.create(modBy);

	public static final String creator = NAME_SPACE + "creator";

	public static final URI creatorURI = URI.create(creator);

	public ObjectProperty getContextRelation() {
		return contextRelation_;
	}

	public ObjectProperty getEntityRelation() {
		return entityRelation_;
	}

	public ObjectProperty getEntityCorrelation() {
		return entityCorrelation_;
	}

	public ObjectProperty getContextCorrelation() {
		return contextCorrelation_;
	}

	public DatatypeProperty getContextId() {
		return contextId_;
	}

	public DatatypeProperty getEntityId() {
		return entityId_;
	}

	public AnnotationProperty getAccessControl() {
		return accessControl_;
	}

	public OntClass getAgent() {
		return agent_;
	}

	public OntClass getGroup() {
		return group_;
	}

	public OntClass getOrganization() {
		return organization_;
	}

	public OntClass getPerson() {
		return person_;
	}

	public OntClass getEntity() {
		return entity_;
	}

	public OntClass getBlankEntity() {
		return blankEntity_;
	}

	public Property getRdfType() {
		return rdfType_;
	}

}
