/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.model.impl;

import java.net.URI;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import com.hp.hpl.jena.ontology.DatatypeProperty;

public class SimpleValueModel implements IAttributeSimpleValueModel {
	private Log log = LogFactory.getLog(SimpleValueModel.class);

	public static final int MAP_MODE_PROPERTY = 1;

	public static final int MAP_MODE_LIST = 2;

	public static final int MAP_MODE_MIXED = 3;

	private boolean isUnique_ = false;

	private ContextModel ctx_ = null;

	private AttributeModel parent_ = null;

	private DatatypeProperty property_ = null;

	private XMLValueModel xmlValueModel_ = null;

	public SimpleValueModel(ContextModel ctx, AttributeModel parent, DatatypeProperty property) throws IdASException {
		ctx_ = ctx;
		parent_ = parent;
		property_ = property;
		initialize();
	}

	private void initialize() throws IdASException {
		initXMLValue();
		initIsUnique();
	}

	private void initXMLValue() throws IdASException {
		xmlValueModel_ = new XMLValueModel(property_, this);
	}

	private void initIsUnique() throws IdASException {
		isUnique_ = property_.isFunctionalProperty();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.ISimpleValueModel#getMaxCardinality()
	 */
	public int getMaxCardinality() throws IdASException {
		throw new IdASException("Not implemented");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.ISimpleValueModel#getMinCardinality()
	 */
	public int getMinCardinality() throws IdASException {
		throw new IdASException("Not implemented");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IAttributeValueModel#isSimple()
	 */
	public boolean isSimple() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.model.IModel#getType()
	 */
	public URI getType() {
		return xmlValueModel_.getType();
	}

	public IAttributeModel getAttribute() {
		return parent_;
	}

	public List getOneOf() {
		return xmlValueModel_.getOneOf();
	}

	public boolean isOneOf() {
		return xmlValueModel_.isOneOf();
	}

	public boolean isValid(String lexicalForm) throws IdASException {
		throw new IdASModelException("Not implemented");
	}

	public boolean isValidValue(Object valueForm) throws IdASException {
		throw new IdASModelException("Not implemented");
	}

	public String toLexicalForm(Object value) throws IdASModelException {
		throw new IdASModelException("Not implemented");
	}

	public Object toValueForm(String lexicalForm) throws IdASModelException {
		throw new IdASModelException("Not implemented");
	}

	public boolean isUnique() {
		return isUnique_;
	}

	public IDisplayData getDisplayData() throws IdASException {
		throw new IdASModelException("Not implemented");
	}

}
