/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;

public class JDBCContextFactory extends AbstractContextFactory {
	private Log log = LogFactory.getLog(JDBCContextFactory.class);

	public JDBCContextFactory() throws IdASException {
		super("org.eclipse.higgins.idas.cp.jena2.db", "jena2.db");
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.JDBCContextFactory::JDBCContextFactory");
	}

	protected IContext createContext(IContextConfiguration config) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.JDBCContextFactory::createContext");
		return new JDBCContext(documentManager, config);
	}

	public IContext createContext(IContextId contextID) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.JDBCContextFactory::createContext");
		return new JDBCContext(documentManager, contextID);
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.JDBCContextFactory::createContext");
	}

}
