/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public abstract class FilterAssertion implements IFilterAssertion {
	private Log log = LogFactory.getLog(FilterAssertion.class);

	protected boolean includeSubtypes_ = false;

	protected String comparator_;

	protected URI type_;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterAssertion#includeSubtypes(boolean)
	 */
	public void includeSubtypes(boolean bIncludeSubtypes) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion::includeSubtypes");
		includeSubtypes_ = bIncludeSubtypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterAssertion#setComparator(java.lang.String)
	 */
	public void setComparator(String comparator) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion::setComparator");
		if (comparator == null
				|| (comparator.equals(IFilterAttributeAssertion.COMP_ATTR_EQ) == false && comparator.equals(IFilterAttributeAssertion.COMP_ATTR_GE) == false
						&& comparator.equals(IFilterAttributeAssertion.COMP_ATTR_LE) == false
						&& comparator.equals(IFilterAttributeAssertion.COMP_ATTR_PRESENT) == false && comparator
						.equals(IFilterAttributeAssertion.COMP_ATTR_SUBSTR) == false))
			throw new IdASException("Unsupported compatator :" + comparator);
		comparator_ = comparator;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterAssertion#setID(java.net.URI,
	 *      boolean)
	 */
	public void setID(URI id, boolean bIncludeSubtypes) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion::setID(URI, boolean)");
		setID(id);
		includeSubtypes(bIncludeSubtypes);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterAssertion#setID(java.net.URI)
	 */
	public void setID(URI id) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion::setID(URI)");
		type_ = id;
	}

	/**
	 * @param context
	 * @throws IdASException
	 */
	abstract public void init(FilterContext context) throws IdASException;

	/**
	 * @return
	 * @throws IdASException
	 */
	abstract public ICondition getCondition() throws IdASException;

}
