/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.model.impl.ContextModel;

public class ContextModelFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$ContextModelFactory == null ? (class$org$eclipse$higgins$idas$model$impl$ContextModelFactory = ContextModelFactory.class$("org.eclipse.higgins.idas.model.impl.ContextModelFactory")) : class$org$eclipse$higgins$idas$model$impl$ContextModelFactory));
    private static HashMap models_ = new HashMap();
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$ContextModelFactory;

    public static IContextModel createContextModel(URI schemaURI, URL schemaURL) throws IdASModelException {
        if (schemaURI == null) {
            throw new IdASModelException("Could not create context model. Parameter \"schemaURI\" is null.");
        }
        if (schemaURL == null) {
            throw new IdASModelException("Could not create context model. Parameter \"schemaURL\" is null.");
        }
        if (models_.containsKey(schemaURI)) {
            return (IContextModel)models_.get(schemaURI);
        }
        try {
            return ContextModelFactory.createModel(schemaURI, schemaURL.openStream());
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new IdASModelException((Throwable)e);
        }
    }

    private static synchronized IContextModel createModel(URI schemaURI, InputStream schemaStream) throws IdASModelException {
        try {
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            model.read(schemaStream, schemaURI.toString());
            ContextModel cm = new ContextModel(model, schemaURI);
            models_.put(schemaURI, cm);
            return cm;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASModelException((Throwable)e);
        }
    }

    public static IContextModel createContextModel(URI schemaURI, File file) throws IdASModelException {
        if (schemaURI == null) {
            throw new IdASModelException("Could not create context model. Parameter \"schemaURI\" is null.");
        }
        if (models_.containsKey(schemaURI)) {
            return (IContextModel)models_.get(schemaURI);
        }
        try {
            URL url = new URL(schemaURI.toString());
            FileInputStream is = new FileInputStream(file);
            return ContextModelFactory.createModel(schemaURI, is);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASModelException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

