/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;

public class ModelUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$ModelUtils == null ? (class$org$eclipse$higgins$idas$model$impl$ModelUtils = ModelUtils.class$("org.eclipse.higgins.idas.model.impl.ModelUtils")) : class$org$eclipse$higgins$idas$model$impl$ModelUtils));
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$ModelUtils;

    public static boolean isClassRelative(OntClass ancestor, OntClass descendant) throws IdASException {
        if (ancestor.equals(descendant)) {
            return true;
        }
        try {
            ExtendedIterator itr = descendant.listSuperClasses();
            while (itr.hasNext()) {
                OntClass cls = (OntClass)itr.next();
                if (!ModelUtils.isClassRelative(ancestor, cls)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    public static boolean isPropertyRelative(OntProperty ancestor, OntProperty descendant) throws IdASException {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.getURI().equals(descendant.getURI())) {
            return true;
        }
        try {
            for (OntProperty tmpDescendant = descendant; tmpDescendant != null; tmpDescendant = tmpDescendant.getSuperProperty()) {
                if (!tmpDescendant.hasSuperProperty((Property)ancestor, false)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    private static void fillListSubClasses(List list, OntClass cls) {
        ExtendedIterator ei = cls.listSubClasses();
        while (ei.hasNext()) {
            OntClass child = (OntClass)ei.next();
            if (child == null || child.isRestriction()) continue;
            list.add(cls);
            ModelUtils.fillListSubClasses(list, cls);
        }
    }

    public static OntClass getSuperClass(OntClass clazz) throws IdASException {
        ExtendedIterator itr = clazz.listSuperClasses();
        while (itr.hasNext()) {
            OntClass cls = (OntClass)itr.next();
            if (cls.isRestriction()) continue;
            return cls;
        }
        return null;
    }

    public static List getListSuperClasses(OntClass ownerClass) throws IdASException {
        ArrayList<OntClass> classesList = new ArrayList<OntClass>();
        OntClass superClass = ModelUtils.getSuperClass(ownerClass);
        while (superClass != null) {
            classesList.add(superClass);
            superClass = ModelUtils.getSuperClass(superClass);
        }
        return classesList;
    }

    public static boolean isPropertyOfClass(OntClass ownerClass, OntProperty property) throws IdASException {
        ArrayList<OntClass> classesList = new ArrayList<OntClass>();
        classesList.add(ownerClass);
        classesList.addAll(ModelUtils.getListSuperClasses(ownerClass));
        for (int i = 0; i < classesList.size(); ++i) {
            OntClass ontClass = (OntClass)classesList.get(i);
            ExtendedIterator ei = property.listDomain();
            while (ei.hasNext()) {
                Object entity = ei.next();
                if (!(entity instanceof OntClass)) continue;
                OntClass domain = (OntClass)entity;
                if (!ontClass.getURI().equals(domain.getURI())) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList getPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        List subClasses = ModelUtils.getListSuperClasses(domainClass);
        Property domain = model.getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        int size = subClasses.size();
        for (int i = 0; i < size; ++i) {
            OntClass cls = (OntClass)subClasses.get(i);
            if (cls == null) continue;
            StmtIterator ei = model.listStatements(null, domain, (RDFNode)cls);
            while (ei.hasNext()) {
                OntProperty property = model.getOntProperty(ei.nextStatement().getSubject().getURI());
                list.add(property);
            }
        }
        return list;
    }

    public static ArrayList getInheritedPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList list = new ArrayList();
        List subClasses = ModelUtils.getListSuperClasses(domainClass);
        int size = subClasses.size();
        for (int i = 0; i < size; ++i) {
            OntClass cls = (OntClass)subClasses.get(i);
            list.addAll(ModelUtils.getOwnPropertiesByDomain(model, cls));
        }
        return list;
    }

    public static ArrayList getOwnPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        Property domain = model.getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        StmtIterator ei = model.listStatements(null, domain, (RDFNode)domainClass);
        while (ei.hasNext()) {
            String propURI = ei.nextStatement().getSubject().getURI();
            OntProperty property = model.getOntProperty(propURI);
            if (property == null) {
                throw new IdASException("Resource with URI = " + propURI + " is not owl:Property.");
            }
            list.add(property);
        }
        return list;
    }

    public static int getMaxCardinality(OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMaxCardinality");
        ExtendedIterator itr = cls.listSuperClasses();
        while (itr.hasNext()) {
            OntClass c = (OntClass)itr.next();
            if (c.isRestriction()) {
                Restriction r = c.asRestriction();
                if (!r.onProperty((Property)attr)) continue;
                if (r.isCardinalityRestriction()) {
                    CardinalityRestriction cr = r.asCardinalityRestriction();
                    return cr.getCardinality();
                }
                if (!r.isMaxCardinalityRestriction()) continue;
                MaxCardinalityRestriction cr = r.asMaxCardinalityRestriction();
                return cr.getMaxCardinality();
            }
            int res = ModelUtils.getMaxCardinality(c, attr);
            if (res == -1) continue;
            return res;
        }
        return -1;
    }

    public static int getMinCardinality(OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMinCardinality");
        ExtendedIterator itr = cls.listSuperClasses(true);
        while (itr.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)attr)) continue;
            if (r.isCardinalityRestriction()) {
                CardinalityRestriction cr = r.asCardinalityRestriction();
                return cr.getCardinality();
            }
            if (!r.isMinCardinalityRestriction()) continue;
            MinCardinalityRestriction cr = r.asMinCardinalityRestriction();
            return cr.getMinCardinality();
        }
        return -1;
    }

    public static boolean isFunctionalProperty(OntModel model, String attributeType) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isFunctionalProperty");
        ObjectProperty op = model.getObjectProperty(attributeType);
        return op != null && op.isFunctionalProperty();
    }

    public static String getModelShortName(OntModel model, OntResource res) {
        String ns = res.getNameSpace();
        String prf = model.getNsURIPrefix(ns);
        String loc = res.getLocalName();
        String val = (prf + "_" + loc).replaceAll("-", "_");
        System.out.println(val);
        return val;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

