/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeNode implements INode {
	private Log log = LogFactory.getLog(AttributeNode.class);

	private int index_ = -1;

	private static String type_ = "attr";

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.INode#getType()
	 */
	public String getType() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode::getType");
		return type_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.INode#hasIndex()
	 */
	public boolean hasIndex() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode::hasIndex");
		if (index_ > -1)
			return true;
		else
			return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.INode#indexRequired()
	 */
	public boolean indexRequired() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode::indexRequired");
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.INode#setIndex(int)
	 */
	public void setIndex(int i) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode::setIndex");
		if (i > -1)
			index_ = i;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.INode#asQueryElement()
	 */
	public String asQueryElement() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode::asQueryElement");
		return "?" + type_ + index_;
	}

}