/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyNode implements INode {
	private Log log = LogFactory.getLog(PropertyNode.class);

	private String type_;

	public PropertyNode(String type) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::PropertyNode");
		type_ = type;
	}

	public String getType() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::getType");
		return type_;
	}

	public boolean hasIndex() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::hasIndex");
		return false;
	}

	public boolean indexRequired() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::indexRequired");
		return false;
	}

	public void setIndex(int i) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::setIndex");
	}

	public String asQueryElement() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode::asQueryElement");
		return "<" + type_ + ">";
	}

}
