/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;

public class TypeCondition implements ICondition {
	private Log log = LogFactory.getLog(TypeCondition.class);

	private TypeNode node_;

	private String typeURI_;
	
	private int level_;

	public TypeCondition(TypeNode node, String typeURI) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeCondition::TypeCondition");
		node_ = node;
		typeURI_ = typeURI;
	}

	public StringBuffer getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeCondition::getCondition");
		StringBuffer buf = new StringBuffer();
		if (level_ == 0)
			buf.append("(");
		buf.append(node_.asQueryElement());
		buf.append(" = ");
		buf.append("<");
		buf.append(typeURI_);
		buf.append(">");
		if (level_ == 0)
			buf.append(")");
		return buf;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition#setLevel(int)
	 */
	public void setLevel(int level) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.TypeCondition::setLevel");
		level_ = level;
	}

}