/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl.authentication;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.common.AuthNSelfIssuedMaterials;
import org.eclipse.higgins.idas.cp.jena2.IAuthenticationModule;
import org.eclipse.higgins.idas.cp.jena2.IUserAccount;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.authentication.PPIDBasedUserAccount;
import org.eclipse.higgins.idas.cp.jena2.impl.authentication.PasswordBasedUserAccount;

public class AuthenticationModule
implements IAuthenticationModule {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule = AuthenticationModule.class$("org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule")) : class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule));
    protected OntModel model_ = null;
    protected OntClass accountClass_ = null;
    protected OntProperty nameProperty_ = null;
    protected OntProperty passwordHashProperty_ = null;
    protected OntProperty tokenProperty_ = null;
    protected Context context_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    public AuthenticationModule(Context context) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::AuthenticationModule");
        if (context == null) {
            throw new IdASException("The parameter \"model\" is null");
        }
        this.context_ = context;
        this.model_ = context.getModelNoException();
        this.accountClass_ = this.initClass("http://www.eclipse.org/higgins/authentication#UserAccount");
        this.nameProperty_ = this.initProperty("http://www.eclipse.org/higgins/authentication#userLogin");
        this.passwordHashProperty_ = this.initProperty("http://www.eclipse.org/higgins/authentication#userPasswordHash");
        this.tokenProperty_ = this.initProperty("http://www.eclipse.org/higgins/authentication#userToken");
    }

    public IUserAccount authenticateNamePasswordMaterials(AuthNNamePasswordMaterials credentials) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::authenticateNamePasswordMaterials");
        String name = credentials.getUsername();
        if (name == null) {
            throw new IdASException("AuthNNamePasswordMaterials contains null username.");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IdASException("AuthNNamePasswordMaterials contains empty string username.");
        }
        String password = credentials.getPassword();
        ArrayList list = this.getAccountIndividuals(name);
        Individual userInd = null;
        switch (list.size()) {
            case 0: {
                try {
                    userInd = this.createNewAccount(name, password);
                    this.context_.applyUpdates();
                    break;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    this.context_.cancelUpdates();
                    throw new IdASException();
                }
            }
            case 1: {
                try {
                    userInd = (Individual)list.get(0);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new IdASException((Throwable)e);
                }
                this.checkPassword(userInd, password);
                break;
            }
            default: {
                throw new IdASException("There are more then one user with name = " + name);
            }
        }
        return new PasswordBasedUserAccount(this.model_, userInd, credentials);
    }

    private Individual getNodeByPPIDAttribute(String ppid) throws IdASException {
        if (ppid == null) {
            return null;
        }
        ISimpleAttrValue sv = this.context_.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, ppid);
        IFilter f = this.context_.buildFilter();
        f.setOperator("urn:eclipse.higgins.idas.OP_AND");
        IFilterAttributeAssertion fas = this.context_.buildAttributeAssertion();
        fas.includeSubtypes(true);
        fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        fas.setAssertionValue((IAttributeValue)sv);
        fas.setID(URI.create("http://www.eclipse.org/higgins/authentication#PPID"));
        f.addFilter((IFilterAssertion)fas);
        ArrayList lst = this.context_.getNodeIndividuals(f, true);
        if (lst.size() == 0) {
            return null;
        }
        if (lst.size() > 1) {
            throw new AuthenticationException("There are more than one Nodes with the same value of http://www.eclipse.org/higgins/authentication#PPID attribute");
        }
        return (Individual)lst.get(0);
    }

    private String getUserTokenByNode(Individual ctxNode) throws IdASException {
        if (ctxNode == null) {
            throw new IdASException("Parameter \"node\" is null.");
        }
        DatatypeProperty dp = this.context_.getModelNoException().getDatatypeProperty("http://www.eclipse.org/higgins/authentication#userToken");
        if (dp == null) {
            throw new IdASException("Can not get datatype property by uri = http://www.eclipse.org/higgins/authentication#userToken");
        }
        RDFNode node = ctxNode.getPropertyValue((Property)dp);
        if (node == null) {
            throw new IdASException("Individual of Node does not have user token property value.");
        }
        if (node.isLiteral()) {
            Literal lt = (Literal)node.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = AuthenticationModule.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
            return lt.getString();
        }
        throw new IdASException("User token property expected to contain literal value.");
    }

    private Individual getUserAccountByToken(String token) throws IdASException {
        if (token == null) {
            throw new IdASException("Parameter \"token\" is null.");
        }
        String query = "SELECT  ?ind \nWHERE { \n\t ?ind <http://www.eclipse.org/higgins/authentication#userToken> \"" + token + "\". \n" + "\t ?ind <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>  <" + "http://www.eclipse.org/higgins/authentication#UserAccount" + ">. \n" + "\n}";
        this.log.debug((Object)query);
        ArrayList<Individual> list = new ArrayList<Individual>();
        Query q = QueryFactory.create((String)query);
        QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.context_.getModelNoException());
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode a = soln.get("ind");
                Individual ind = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? AuthenticationModule.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                list.add(ind);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
        finally {
            qexec.close();
        }
        this.log.debug((Object)("Number of selected individuals by query : " + list.size()));
        if (list.size() == 1) {
            return (Individual)list.get(0);
        }
        throw new IdASException("Number of user accounts with required user token = " + list.size());
    }

    public IUserAccount authenticateSelfIssuedMaterials(AuthNSelfIssuedMaterials credentials) throws IdASException {
        if (credentials == null) {
            return null;
        }
        String ppid = null;
        ByteArrayOutputStream cardKey = new ByteArrayOutputStream();
        try {
            cardKey.write(credentials.getPPIDBytes());
            cardKey.write(credentials.getPublicKeyModBytes());
            cardKey.write(credentials.getPublicKeyExpBytes());
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(cardKey.toByteArray());
            ppid = Base64.encode((byte[])hash).trim();
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
        Individual ds = this.getNodeByPPIDAttribute(ppid);
        String userToken = this.getUserTokenByNode(ds);
        Individual ind = this.getUserAccountByToken(userToken);
        if (ind == null) {
            return null;
        }
        return new PPIDBasedUserAccount(this.model_, ind, credentials);
    }

    public IUserAccount authenticate(Object credentials) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::authenticate");
        if (credentials instanceof AuthNNamePasswordMaterials) {
            AuthNNamePasswordMaterials am = (AuthNNamePasswordMaterials)credentials;
            return this.authenticateNamePasswordMaterials(am);
        }
        if (credentials instanceof AuthNSelfIssuedMaterials) {
            AuthNSelfIssuedMaterials am = (AuthNSelfIssuedMaterials)credentials;
            return this.authenticateSelfIssuedMaterials(am);
        }
        throw new IdASException("Unsupported credentials type.");
    }

    private Individual createNewAccount(String name, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::createNewAccount");
        Individual userInd = this.model_.createIndividual((Resource)this.accountClass_);
        Literal nameLtr = this.model_.createLiteral(name);
        userInd.setPropertyValue((Property)this.nameProperty_, (RDFNode)nameLtr);
        String token = name;
        Literal tokenLtr = this.model_.createLiteral(token);
        userInd.setPropertyValue((Property)this.tokenProperty_, (RDFNode)tokenLtr);
        this.setNewPassword(userInd, password);
        return userInd;
    }

    private void setNewPassword(Individual user, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::setNewPassword");
        String newHash = null;
        byte[] bytes = this.getHash(password);
        if (bytes != null) {
            newHash = Base64.encode((byte[])bytes);
        }
        if (newHash != null) {
            Literal ltr = this.model_.createLiteral(newHash);
            user.setPropertyValue((Property)this.passwordHashProperty_, (RDFNode)ltr);
        } else {
            RDFNode node = user.getPropertyValue((Property)this.passwordHashProperty_);
            if (node != null) {
                user.removeProperty((Property)this.passwordHashProperty_, node);
            }
        }
    }

    private void checkPassword(Individual userInd, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::checkPassword");
        String passHash = null;
        RDFNode rdfNode = userInd.getPropertyValue((Property)this.passwordHashProperty_);
        if (!rdfNode.isLiteral()) {
            throw new IdASException("Value of property " + this.passwordHashProperty_.getURI() + " is not literal.");
        }
        Literal litr = (Literal)rdfNode.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = AuthenticationModule.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
        Object obj = litr.getValue();
        if (obj != null) {
            passHash = obj.toString();
        }
        if (passHash == null || passHash.length() == 0) {
            if (password != null && password.length() > 0) {
                throw new IdASException("Wrong password.");
            }
        } else {
            if (password == null || password.length() == 0) {
                throw new IdASException("Wrong password.");
            }
            byte[] realPassHash = null;
            byte[] testedHash = null;
            testedHash = this.getHash(password);
            try {
                realPassHash = Base64.decode((String)passHash);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
            if (!Arrays.equals(realPassHash, testedHash)) {
                throw new IdASException("Wrong password.");
            }
        }
    }

    private OntClass initClass(String name) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::initClass");
        OntClass ontClass = this.model_.getOntClass(name);
        if (ontClass == null) {
            try {
                ontClass = this.model_.createClass(name);
                this.context_.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                this.context_.cancelUpdates();
                throw new IdASException();
            }
        }
        return ontClass;
    }

    private OntProperty initProperty(String name) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::initProperty");
        OntProperty prop = this.model_.getOntProperty(name);
        if (prop == null) {
            try {
                prop = this.model_.createDatatypeProperty(name);
                this.context_.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                this.context_.cancelUpdates();
                throw new IdASException();
            }
        }
        return prop;
    }

    private byte[] getHash(String str) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::getHash");
        if (str != null && str.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return md.digest(str.getBytes("UTF-8"));
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAccountIndividuals(String userName) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::getAccountIndividuals");
        String query = "SELECT ?ind \nWHERE { \n  ?ind <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.eclipse.org/higgins/authentication#UserAccount>. \n  ?ind <http://www.eclipse.org/higgins/authentication#userLogin> \"" + userName + "\" \n" + "}";
        this.log.debug((Object)query);
        ArrayList<Individual> list = new ArrayList<Individual>();
        QueryExecution qexec = null;
        try {
            try {
                Query q = QueryFactory.create((String)query);
                qexec = QueryExecutionFactory.create((Query)q, (Model)this.context_.getModelNoException());
                ResultSet results = qexec.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    RDFNode a = soln.get("ind");
                    Individual node = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? AuthenticationModule.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                    list.add(node);
                }
                Object var11_11 = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (qexec == null) throw throwable;
                qexec.close();
                throw throwable;
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new IdASException((Throwable)e1);
            }
        }
        try {}
        catch (Exception e1) {
            this.log.error((Object)e1);
            throw new IdASException((Throwable)e1);
        }
        if (qexec != null) {
            qexec.close();
        }
        this.log.debug((Object)("Users count by query: " + list.size()));
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

