/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.model.impl.AttributeModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.ModelUtils;

public class EntityModel
implements IEntityModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$EntityModel == null ? (class$org$eclipse$higgins$idas$model$impl$EntityModel = EntityModel.class$("org.eclipse.higgins.idas.model.impl.EntityModel")) : class$org$eclipse$higgins$idas$model$impl$EntityModel));
    private ContextModel ctx_ = null;
    private OntClass entityClass_ = null;
    private URI type_ = null;
    private String parentType_ = null;
    private List allAttrList_ = null;
    private List ownAttrList_ = null;
    private List inheritedAttrList_ = null;
    private List subEntities_ = null;
    private Hashtable attrMap_ = null;
    private String modelID_ = null;
    private HashMap attrToMinCardinality_ = null;
    private HashMap attrToMaxCardinality_ = null;
    private EntityModel parent_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$EntityModel;

    public EntityModel(OntClass entityClass, EntityModel parent, ContextModel ctx) throws Exception {
        this.entityClass_ = entityClass;
        this.ctx_ = ctx;
        this.parent_ = parent;
        this.subEntities_ = new ArrayList();
        this.initialize();
    }

    private void initialize() throws Exception {
        this.modelID_ = ModelUtils.getModelShortName(this.ctx_.getOntModel(), (OntResource)this.entityClass_);
        this.initType();
        this.initSubType();
        this.initAttributes();
        this.initDisplayData();
        this.initCardinality();
    }

    private void initSubType() throws IdASException {
        OntClass cls = ModelUtils.getSuperClass(this.entityClass_);
        if (cls != null) {
            this.parentType_ = cls.getURI();
        }
    }

    private void initType() throws IdASException {
        try {
            this.type_ = new URI(this.entityClass_.getURI());
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new IdASModelException("The entity class " + this.entityClass_.getURI() + " is not valid URI", (Throwable)e);
        }
    }

    private void initAttributes() throws IdASException {
        this.attrMap_ = new Hashtable();
        this.allAttrList_ = new ArrayList();
        ArrayList own = ModelUtils.getOwnPropertiesByDomain(this.ctx_.getOntModel(), this.entityClass_);
        this.ownAttrList_ = this.initAttributes(own);
        ArrayList inherited = ModelUtils.getInheritedPropertiesByDomain(this.ctx_.getOntModel(), this.entityClass_);
        this.inheritedAttrList_ = this.initAttributes(inherited);
        this.allAttrList_.addAll(this.ownAttrList_);
        this.allAttrList_.addAll(this.inheritedAttrList_);
    }

    private ArrayList initAttributes(ArrayList properties) throws IdASException {
        ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>();
        OntModel mdl = this.ctx_.getOntModel();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            OntProperty p = (OntProperty)properties.get(i);
            AttributeModel m = null;
            if (p.isDatatypeProperty()) {
                DatatypeProperty dp = p.asDatatypeProperty();
                m = new AttributeModel(this.ctx_, dp, this);
                attributeModels.add(m);
                this.attrMap_.put(m.getType(), m);
                continue;
            }
            if (!p.isObjectProperty()) continue;
            if (ModelUtils.isPropertyRelative((OntProperty)this.ctx_.getHigginsVocabulary().getEntityRelation(), p)) {
                this.initRelation();
                continue;
            }
            if (ModelUtils.isPropertyRelative((OntProperty)this.ctx_.getHigginsVocabulary().getEntityCorrelation(), p)) {
                this.initCorelation();
                continue;
            }
            ObjectProperty op = p.asObjectProperty();
            m = new AttributeModel(this.ctx_, op, this);
            attributeModels.add(m);
            this.attrMap_.put(m.getType(), m);
        }
        return attributeModels;
    }

    private void initRelation() throws IdASException {
    }

    private void initCorelation() throws IdASException {
    }

    private void initDisplayData() throws IdASException {
    }

    public Iterator getAttributeModels() {
        return this.allAttrList_.iterator();
    }

    public Iterator getOwnAttributeModels() {
        return this.ownAttrList_.iterator();
    }

    public Iterator getInheritedAttributeModels() {
        return this.inheritedAttrList_.iterator();
    }

    public URI getType() {
        return this.type_;
    }

    public IAttributeModel getAttributeModel(URI type) {
        if (type == null) {
            return null;
        }
        if (this.attrMap_.containsKey(type)) {
            return (IAttributeModel)this.attrMap_.get(type);
        }
        return null;
    }

    public IModel getModel(URI modelURI) {
        return null;
    }

    public OntClass getOntClass() {
        return this.entityClass_;
    }

    public String getId() {
        return this.modelID_;
    }

    public String getParentType() {
        return this.parentType_;
    }

    public int getMinCardinality(String attrType) {
        if (this.attrToMinCardinality_.containsKey(attrType)) {
            Integer i = (Integer)this.attrToMinCardinality_.get(attrType);
            return i;
        }
        return 0;
    }

    public int getMaxCardinality(String attrType) {
        if (this.attrToMaxCardinality_.containsKey(attrType)) {
            Integer i = (Integer)this.attrToMaxCardinality_.get(attrType);
            return i;
        }
        return 0;
    }

    private void initCardinality() throws IdASException {
        this.attrToMinCardinality_ = new HashMap();
        this.attrToMaxCardinality_ = new HashMap();
        OntClass cls = this.entityClass_;
        while (cls != null) {
            ExtendedIterator itr = cls.listSuperClasses(true);
            while (itr.hasNext()) {
                Integer cardinality;
                CardinalityRestriction cr;
                Restriction r;
                OntProperty prop;
                OntClass c = (OntClass)itr.next();
                if (!c.isRestriction() || (prop = (r = c.asRestriction()).getOnProperty()) == null) continue;
                String propType = prop.getURI();
                if (r.isCardinalityRestriction()) {
                    cr = r.asCardinalityRestriction();
                    cardinality = new Integer(cr.getCardinality());
                    this.attrToMinCardinality_.put(propType, cardinality);
                    this.attrToMaxCardinality_.put(propType, cardinality);
                    continue;
                }
                if (r.isMaxCardinalityRestriction()) {
                    cr = r.asMaxCardinalityRestriction();
                    cardinality = new Integer(cr.getMaxCardinality());
                    this.attrToMaxCardinality_.put(propType, cardinality);
                    continue;
                }
                if (!r.isMinCardinalityRestriction()) continue;
                cr = r.asMinCardinalityRestriction();
                cardinality = new Integer(cr.getMinCardinality());
                this.attrToMinCardinality_.put(propType, cardinality);
            }
            cls = ModelUtils.getSuperClass(cls);
        }
    }

    public boolean isBlankNode() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IEntityModel getParentEntity() {
        return this.parent_;
    }

    public void addSubEntity(EntityModel child) {
        this.subEntities_.add(child);
    }

    public List getSubEntities() {
        return this.subEntities_;
    }

    public IDisplayData getDisplayData() throws IdASException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

