/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IUserAccount;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;

public abstract class UserAccount implements IUserAccount {
	private Log log = LogFactory.getLog(UserAccount.class);

	protected Individual accountInd_ = null;

	protected OntModel model_ = null;

	protected String token_ = null;

	protected Object credentials_ = null;

	/**
	 * @param model
	 * @param accountInd
	 * @param credentials
	 * @throws IdASException
	 */
	public UserAccount(OntModel model, Individual accountInd, Object credentials) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.authentication.UserAccount::UserAccount");
		if (model == null)
			throw new IdASException("The parameter \"model\" is null");
		if (accountInd == null)
			throw new IdASException("The parameter \"accountInd\" is null");
		if (credentials == null)
			throw new IdASException("The parameter \"credentials\" is null");
		model_ = model;
		accountInd_ = accountInd;
		credentials_ = credentials;
		Property tokenProp = model_.getProperty(AuthConstants.USER_TOKEN_PROPERTY);
		if (tokenProp == null)
			throw new IdASException("Can not find property " + AuthConstants.USER_TOKEN_PROPERTY);
		RDFNode node = accountInd_.getPropertyValue(tokenProp);
		if (node != null) {
			if (node.isLiteral() == false)
				throw new IdASException("Property " + AuthConstants.USER_TOKEN_PROPERTY + " contains non-literal value.");
			Literal ltr = (Literal) node.as(Literal.class);
			if (ltr != null) {
				Object obj = ltr.getValue();
				if (obj != null)
					token_ = obj.toString();
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.IUserAccount#getCredentials()
	 */
	public Object getCredentials() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.authentication.UserAccount::getCredentials");
		return credentials_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.IUserAccount#getUserToken()
	 */
	public String getUserToken() {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.authentication.UserAccount::getUserToken");
		return token_;
	}

}
