/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FilterTypeAssertion extends FilterAssertion implements IFilterEntityTypeAssertion {
	private Log log = LogFactory.getLog(FilterTypeAssertion.class);

	private static final PropertyNode typeProperty_ = new PropertyNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");

	private FilterContext filterContext_ = null;

	private Context idasContext_ = null;

	private CompoundCondition condition_ = null;

	public FilterTypeAssertion(Context context) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::FilterTypeAssertion");
		idasContext_ = context;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion#setAssertionValue(java.net.URI)
	 */
	public void setAssertionValue(URI assertion) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::setAssertionValue");
		setID(assertion);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#getCondition()
	 */
	public ICondition getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::getCondition");
		if (condition_ == null)
			throw new IdASException("Can't return condition. FilterAttributeAssertion should be initialized before.");
		return condition_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#init(org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext)
	 */
	public void init(FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterTypeAssertion::init");
		filterContext_ = filterContext;
		if (idasContext_ == null)
			throw new IdASException("Can't init FilterTypeAssertion because idasContext is null.");
		if (type_ == null)
			throw new IdASException("Can't init FilterTypeAssertion because type is null.");
		String type = type_.toString();
		ArrayList types = new ArrayList();
		if (includeSubtypes_) {
			OntClass node = idasContext_.getOntClass(type);
			List subClasses = ModelUtils.getListSubClasses(filterContext.getIdASContext(), node);
			Iterator it = subClasses.iterator();
			while (it.hasNext()) {
				OntClass subClass = (OntClass)it.next();
				types.add(subClass.getURI());
			}
		}
		else {
			types.add(type);
		}
		condition_ = new CompoundCondition(Filter.OP_OR);
		GraphPattern pattern = filterContext_.registerPattern(new GraphPattern(filterContext_.getSubjectNode(), typeProperty_, new TypeNode(), null));
		TypeNode typeNode = (TypeNode)pattern.getObject();
		int typesCount = types.size();
		for (int i = 0; i < typesCount; i++) {
			String subType = (String)types.get(i);
			condition_.addCondition(new TypeCondition(typeNode, subType));
		}
	}
}
