/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2;

import java.security.Key;

import org.eclipse.higgins.idas.api.IdASException;

public interface IUserAccount {

	
	/**
	 * @return The symmetric key used to encrypt/decrypt user's data. 
	 * This key should be held in the user's account in encrypted form.
	 * The user's credentials should be used to encrypt/decrypt it.  
	 * @throws IdASException
	 */
	public Key getKey() throws IdASException;

	/**
	 * @return The token used to mark user subjects.
	 * Should be unique for each user within the context or null. 
	 * If this value is not null, the user opened the context can operate (get|modify|delete) only with subjects marked with this token (Individual of DigitalSibject should have $userToken datatype property with this value).
	 * If this value is null, the user opened the context has unlimited access to the context. 
	 * @throws IdASException
	 */
	public String getUserToken() throws IdASException;

	/**
	 * @return Credentials used to open the context.
	 */
	public Object getCredentials();

}
