/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.authentication;

public class AuthConstants {

	final public static String NS = "http://www.eclipse.org/higgins/authentication";

	/**
	 * Individual of this class holds user's account data
	 */
	final public static String USER_ACCOUNT_CLASS = NS + "#UserAccount";

	/**
	 * The name of datatype property used to hold the type of authentication
	 * allowed for user.
	 */
	final public static String USER_AUTHENTICATION_TYPE_PROPERTY = NS + "#userAuthenticationType";

	/**
	 * 1. Individual of user's account can have this property. 2. If
	 * individual of account has such not-null property, the user can only
	 * operate with Nodes marked with this token (in this case an
	 * individual of Nodes has "$userToken" with this value).
	 */
	final public static String USER_TOKEN_PROPERTY = NS + "#userToken";

	/**
	 * Base64-encoded value of encrypted symmetric key used to encrypt/decrypt
	 * user's data. This key should be encrypted with another symmetryc key
	 * generated using credentials (using password, e.g.).
	 */
	final public static String USER_KEY_PROPERTY = NS + "#userKey";

	/**
	 * The name of datatype property used to hold login of user's account. Is
	 * used in case of username/password authentication.
	 */
	final public static String USER_NAME_PROPERTY = NS + "#userLogin";

	/**
	 * The name of datatype property used to hold SHA-256 hash value of password
	 * of user's account. Is used in case of username/password authentication.
	 */
	final public static String USER_PASSWORD_HASH_PROPERTY = NS + "#userPasswordHash";

	/**
	 * The name of datatype property used to hold PPID value of user's account.
	 */
	final public static String USER_PPID_PROPERTY = NS + "#PPID";

}
