package org.eclipse.higgins.idas.cp.jena2.util;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;

public class XMLDateConvertor {
	private static Log log = LogFactory.getLog(XMLDateConvertor.class);

	private static SimpleDateFormat zeroTZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
	private static SimpleDateFormat rfc822TZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
	
	private static Date parseAsZeroTimeZoneFormat(String date) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.util.XMLDateConvertor::parseAsZeroTimeZoneFormat");
		Date res = null;
		try {
			if (date.matches(".*Z$"))
				res = zeroTZFormat.parse(date);
		}
		catch(ParseException e) {
		}
		return res;
	}
	
	private static Date parseAsRFC822ZoneFormat(String date) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.util.XMLDateConvertor::parseAsRFC822ZoneFormat");
		Date res = null;
		try {
			int indx = date.lastIndexOf(":");
			if (indx != -1) {
				String dt = date.substring(0, indx) + date.substring(indx + 1, date.length());
				res = rfc822TZFormat.parse(dt);
			}
		}
		catch(ParseException e) {
		}
		return res;
	}
	
	public static Date parse(String date) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.util.XMLDateConvertor::parse");
		if (date != null) {
			String dateTrim = date.trim();
			Date dt = null;
			dt = parseAsZeroTimeZoneFormat(dateTrim);
			if (dt == null)
				dt = parseAsRFC822ZoneFormat(dateTrim);
			if (dt == null)
				throw new IdASException("Could't parse date : " + date);
			return dt;
		}
		else
			return null;
	}

	public static String format(Date date) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.util.XMLDateConvertor::format");
		if (date == null)
			return "";
		else
			return zeroTZFormat.format(date);
	}
}
