/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.cp.jena2.util.XMLValueHelper;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.rdf.model.Literal;

public class SimpleValue implements ISimpleAttrValue {
	private Log log = LogFactory.getLog(SimpleValue.class);

	protected Context context_ = null;

	protected Attribute attribute_ = null;

	protected IAttributeSimpleValueModel valueModel_ = null;

	protected Individual owner_ = null;

	protected DatatypeProperty property_ = null;

	protected Literal value_ = null;

	protected XMLValueHelper valueHelper_ = null;

	protected URI xmlType_ = null;

	protected Entity subject_ = null;

	public SimpleValue(Context context, Attribute attribute, Individual container, DatatypeProperty attributeProperty, Literal value)
			throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::SimpleValue");
		if (context == null)
			throw new IdASException("Parameter \"context\" is null.");
		if (attribute == null)
			throw new IdASException("Parameter \"attribute\" is null.");
		if (container == null)
			throw new IdASException("Parameter \"container\" is null.");
		context_ = context;
		attribute_ = attribute;
		subject_ = attribute.getSubjectOwner();
		owner_ = attribute.getOwner();
		property_ = attributeProperty;
		IAttributeModel attrModel = attribute_.getModel();
		valueModel_ = (IAttributeSimpleValueModel) attribute_.getModel().getValueModel();
		value_ = value;
		valueHelper_ = XMLValueHelper.getInstance(valueModel_.getType().toString());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IAttributeValue#isSimple()
	 */
	public boolean isSimple() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::isSimple");
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#getDataType()
	 */
	public URI getDataType() throws IdASException {
		return getValueType();
	}

	public URI getValueType() throws IdASException {
		return valueModel_.getType();
	}

	public boolean equals(IAttributeValue value) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

	public String getCanonical() throws IdASException {
		return getLexical();
	}

	public Object getData() throws IdASException {
		if (value_ != null)
			return valueHelper_.toValueForm(value_);
		else
			return null;
	}

	public String getLexical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.XMLValue::getLexical");
		Object data = getData();
		return data != null ? valueHelper_.toLexicalForm(data) : null;
	}

	public void setData(Object data) throws IdASException {
		context_.registerChangedSubject(subject_);
		if (value_ != null) {
			owner_.removeProperty(property_, value_);
		}
		if (data != null) {
			String lexicalForm = valueHelper_.toLexicalForm(data);
			value_ = context_.getModel().createTypedLiteral(lexicalForm, valueModel_.getType().toString());
			owner_.addProperty(property_, value_);
		}
	}

	public void remove() throws IdASException {
		context_.registerChangedSubject(subject_);
		owner_.removeProperty(property_, value_);
	}

	public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
		// TODO Auto-generated method stub
		return null;
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean equals(IHasAttributes attributes) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public Iterator getAttributes() throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
		// TODO Auto-generated method stub
		return null;
	}

	public void removeAttribute(URI attrID) throws IdASException {
		// TODO Auto-generated method stub

	}

	public void removeAttributeValue(URI attrID, Object value) throws IdASException {
		// TODO Auto-generated method stub

	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {
		// TODO Auto-generated method stub

	}

	public IAttributeSimpleValueModel getModel() throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

}
