package org.eclipse.higgins.idas.cp.jena2.plugin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class Jena2Plugin extends Plugin {

	private static Log log = LogFactory.getLog(Jena2Plugin.class);
	
	//The shared instance.
	private static Jena2Plugin plugin;
	
	/**
	 * The constructor.
	 */
	public Jena2Plugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		log.info(this.getClass().getName() + " started");
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static Jena2Plugin getDefault() {
		return plugin;
	}

}
