/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;

public final class BufferingXmlWriter
extends XmlWriter
implements XMLStreamConstants {
    static final int DEFAULT_BUFFER_SIZE = 1000;
    static final int DEFAULT_SMALL_SIZE = 256;
    protected static final int HIGHEST_ENCODABLE_ATTR_CHAR = 60;
    protected static final int HIGHEST_ENCODABLE_TEXT_CHAR = 62;
    protected Writer mOut;
    protected char[] mOutputBuffer;
    protected final int mSmallWriteSize;
    protected int mOutputPtr;
    protected int mOutputBufLen;
    private final int mEncHighChar;
    final char mEncQuoteChar;
    final String mEncQuoteEntity;

    public BufferingXmlWriter(Writer out, WriterConfig cfg, String enc, boolean autoclose) throws IOException {
        super(cfg, enc, autoclose);
        this.mOut = out;
        this.mOutputBuffer = cfg.allocFullCBuffer(1000);
        this.mOutputBufLen = this.mOutputBuffer.length;
        this.mSmallWriteSize = 256;
        this.mOutputPtr = 0;
        this.mEncQuoteChar = (char)34;
        this.mEncQuoteEntity = "&quot;";
        int bitsize = BufferingXmlWriter.guessEncodingBitSize(enc);
        this.mEncHighChar = bitsize < 16 ? 1 << bitsize : 65534;
    }

    protected int getOutputPtr() {
        return this.mOutputPtr;
    }

    public void close() throws IOException {
        if (this.mOut != null) {
            this.flush();
            Writer w = this.mOut;
            this.mOut = null;
            this.mTextWriter = null;
            this.mAttrValueWriter = null;
            char[] buf = this.mOutputBuffer;
            this.mOutputBuffer = null;
            this.mConfig.freeFullCBuffer(buf);
            if (this.mAutoCloseOutput) {
                w.close();
            }
        }
    }

    public final void flush() throws IOException {
        if (this.mOut != null) {
            this.flushBuffer();
            this.mOut.flush();
        }
    }

    public void writeRaw(char[] cbuf, int offset, int len) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this.mOutputPtr + len > this.mOutputBufLen) {
                this.flushBuffer();
            }
            int ptr = this.mOutputPtr;
            char[] outBuf = this.mOutputBuffer;
            len += offset;
            while (offset < len) {
                outBuf[ptr] = cbuf[offset];
                ++offset;
                ++ptr;
            }
            this.mOutputPtr = ptr;
            return;
        }
        int ptr = this.mOutputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                char[] outBuf = this.mOutputBuffer;
                int needed = this.mSmallWriteSize - ptr;
                if (len - needed < this.mSmallWriteSize) {
                    len += offset;
                    do {
                        outBuf[ptr++] = cbuf[offset++];
                    } while (offset < len);
                    this.mOutputPtr = ptr;
                    return;
                }
                int last = ptr + needed;
                do {
                    outBuf[ptr++] = cbuf[offset++];
                } while (ptr < last);
                this.mOutputPtr = ptr;
                len -= needed;
            }
            this.flushBuffer();
        }
        this.mOut.write(cbuf, offset, len);
    }

    public void writeRaw(String str, int offset, int len) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (len < this.mSmallWriteSize) {
            if (this.mOutputPtr + len >= this.mOutputBufLen) {
                this.flushBuffer();
            }
            int ptr = this.mOutputPtr;
            char[] outBuf = this.mOutputBuffer;
            len += offset;
            while (offset < len) {
                outBuf[ptr] = str.charAt(offset);
                ++offset;
                ++ptr;
            }
            this.mOutputPtr = ptr;
            return;
        }
        int ptr = this.mOutputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                char[] outBuf = this.mOutputBuffer;
                int needed = this.mSmallWriteSize - ptr;
                if (len - needed < this.mSmallWriteSize) {
                    len += offset;
                    do {
                        outBuf[ptr++] = str.charAt(offset++);
                    } while (offset < len);
                    this.mOutputPtr = ptr;
                    return;
                }
                int last = ptr + needed;
                do {
                    outBuf[ptr++] = str.charAt(offset++);
                } while (ptr < last);
                this.mOutputPtr = ptr;
                len -= needed;
            }
            this.flushBuffer();
        }
        this.mOut.write(str, offset, len);
    }

    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    public final void writePIStart(String target, boolean addSpace) throws IOException {
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(target);
        if (addSpace) {
            this.fastWriteRaw(' ');
        }
    }

    public final void writePIEnd() throws IOException {
        this.fastWriteRaw('?', '>');
    }

    public int writeCData(String data) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCDataContent(data)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedCData(data, ix);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(data, 0, data.length());
        this.fastWriteRaw("]]>");
        return -1;
    }

    public int writeCData(char[] cbuf, int offset, int len) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCDataContent(cbuf, offset, len)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedCData(cbuf, offset, len, ix);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cbuf, offset, len);
        this.fastWriteRaw("]]>");
        return -1;
    }

    public void writeCharacters(String text) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(text);
        } else {
            int offset = 0;
            int len = text.length();
            do {
                int outLen;
                char c = '\u0000';
                int highChar = this.mEncHighChar;
                int start = offset;
                String ent = null;
                while (offset < len) {
                    c = text.charAt(offset);
                    if (c <= '>') {
                        if (c == '<') {
                            ent = "&lt;";
                            break;
                        }
                        if (c == '&') {
                            ent = "&amp;";
                            break;
                        }
                        if (c == '>') {
                            if (offset == start || text.charAt(offset - 1) == ']') {
                                ent = "&gt;";
                                break;
                            }
                        } else if (c < ' ' && c != '\n' && c != '\t') {
                            if (c == '\r' || this.mXml11 && c != '\u0000') break;
                            this.throwInvalidChar(c);
                            break;
                        }
                    } else if (c >= highChar) break;
                    ++offset;
                }
                if ((outLen = offset - start) > 0) {
                    this.writeRaw(text, start, outLen);
                }
                if (ent != null) {
                    this.writeRaw(ent);
                    ent = null;
                    continue;
                }
                if (offset >= len) continue;
                this.writeAsEntity(c);
            } while (++offset < len);
        }
    }

    public void writeCharacters(char[] cbuf, int offset, int len) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(cbuf, offset, len);
        } else {
            len += offset;
            do {
                int outLen;
                char c = '\u0000';
                int highChar = this.mEncHighChar;
                int start = offset;
                String ent = null;
                while (offset < len) {
                    c = cbuf[offset];
                    if (c <= '>') {
                        if (c == '<') {
                            ent = "&lt;";
                            break;
                        }
                        if (c == '&') {
                            ent = "&amp;";
                            break;
                        }
                        if (c == '>') {
                            if (offset == start || cbuf[offset - 1] == ']') {
                                ent = "&gt;";
                                break;
                            }
                        } else if (c < ' ' && c != '\n' && c != '\t') {
                            if (c == '\r' || this.mXml11 && c != '\u0000') break;
                            this.throwInvalidChar(c);
                            break;
                        }
                    } else if (c >= highChar) break;
                    ++offset;
                }
                if ((outLen = offset - start) > 0) {
                    this.writeRaw(cbuf, start, outLen);
                }
                if (ent != null) {
                    this.writeRaw(ent);
                    ent = null;
                    continue;
                }
                if (offset >= len) continue;
                this.writeAsEntity(c);
            } while (++offset < len);
        }
    }

    public int writeComment(String data) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCommentContent(data)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedComment(data, ix);
            return -1;
        }
        this.fastWriteRaw("<!--");
        this.writeRaw(data, 0, data.length());
        this.fastWriteRaw("-->");
        return -1;
    }

    public void writeDTD(String data) throws IOException {
        this.writeRaw(data, 0, data.length());
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        if (this.mCheckNames) {
            this.verifyNameValidity(rootName, false);
        }
        this.fastWriteRaw(rootName);
        if (systemId != null) {
            if (publicId != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(publicId);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(systemId);
            this.fastWriteRaw('\"');
        }
        if (internalSubset != null && internalSubset.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(internalSubset);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    public void writeEntityReference(String name) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(name, this.mNsAware);
        }
        this.fastWriteRaw('&');
        this.fastWriteRaw(name);
        this.fastWriteRaw(';');
    }

    public void writeXmlDeclaration(String version, String encoding, String standalone) throws IOException {
        this.fastWriteRaw("<?xml version='");
        this.fastWriteRaw(version);
        this.fastWriteRaw('\'');
        if (encoding != null && encoding.length() > 0) {
            this.fastWriteRaw(" encoding='");
            this.fastWriteRaw(encoding);
            this.fastWriteRaw('\'');
        }
        if (standalone != null) {
            this.fastWriteRaw(" standalone='");
            this.fastWriteRaw(standalone);
            this.fastWriteRaw('\'');
        }
        this.fastWriteRaw('?', '>');
    }

    public int writePI(String target, String data) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(target, this.mNsAware);
        }
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(target);
        if (data != null && data.length() > 0) {
            int ix;
            if (this.mCheckContent && (ix = data.indexOf(63)) >= 0 && (ix = data.indexOf("?>", ix)) >= 0) {
                return ix;
            }
            this.fastWriteRaw(' ');
            this.writeRaw(data, 0, data.length());
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    public void writeStartTagStart(String prefix, String localName) throws IOException, XMLStreamException {
        this.fastWriteRaw('<');
        if (prefix != null && prefix.length() > 0) {
            if (this.mCheckNames) {
                this.verifyNameValidity(prefix, this.mNsAware);
            }
            this.fastWriteRaw(prefix);
            this.fastWriteRaw(':');
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        this.fastWriteRaw(localName);
    }

    public void writeStartTagEnd() throws IOException {
        this.fastWriteRaw('>');
    }

    public void writeStartTagEmptyEnd() throws IOException {
        this.fastWriteRaw(" />");
    }

    public void writeEndTag(String prefix, String localName) throws IOException {
        this.fastWriteRaw('<', '/');
        if (prefix != null && prefix.length() > 0) {
            this.fastWriteRaw(prefix);
            this.fastWriteRaw(':');
        }
        this.fastWriteRaw(localName);
        this.fastWriteRaw('>');
    }

    public void writeAttribute(String prefix, String localName, String value) throws IOException, XMLStreamException {
        int len;
        if (this.mOut == null) {
            return;
        }
        this.fastWriteRaw(' ');
        if (prefix != null && prefix.length() > 0) {
            if (this.mCheckNames) {
                this.verifyNameValidity(prefix, this.mNsAware);
            }
            this.fastWriteRaw(prefix);
            this.fastWriteRaw(':');
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        this.fastWriteRaw(localName);
        this.fastWriteRaw('=', '\"');
        int n = len = value == null ? 0 : value.length();
        if (len > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value, 0, len);
            } else {
                char qchar = this.mEncQuoteChar;
                int offset = 0;
                int highChar = this.mEncHighChar;
                do {
                    int outLen;
                    int start = offset;
                    char c = '\u0000';
                    String ent = null;
                    while (offset < len) {
                        c = value.charAt(offset);
                        if (c <= '<') {
                            if (c == qchar) {
                                ent = this.mEncQuoteEntity;
                                break;
                            }
                            if (c == '<') {
                                ent = "&lt;";
                                break;
                            }
                            if (c == '&') {
                                ent = "&amp;";
                                break;
                            }
                            if (c < ' ') {
                                if (c == '\n' || c == '\r' || c == '\t' || this.mXml11 && c != '\u0000') break;
                                this.throwInvalidChar(c);
                                break;
                            }
                        } else if (c >= highChar) break;
                        ++offset;
                    }
                    if ((outLen = offset - start) > 0) {
                        this.writeRaw(value, start, outLen);
                    }
                    if (ent != null) {
                        this.fastWriteRaw(ent);
                        ent = null;
                        continue;
                    }
                    if (offset >= len) continue;
                    this.writeAsEntity(c);
                } while (++offset < len);
            }
        }
        this.fastWriteRaw('\"');
    }

    private final void flushBuffer() throws IOException {
        if (this.mOutputPtr > 0 && this.mOut != null) {
            int ptr = this.mOutputPtr;
            this.mLocPastChars += ptr;
            this.mLocRowStartOffset -= ptr;
            this.mOutputPtr = 0;
            this.mOut.write(this.mOutputBuffer, 0, ptr);
        }
    }

    private final void fastWriteRaw(char c) throws IOException {
        if (this.mOutputPtr >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c;
    }

    private final void fastWriteRaw(char c1, char c2) throws IOException {
        if (this.mOutputPtr + 1 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c1;
        this.mOutputBuffer[this.mOutputPtr++] = c2;
    }

    private final void fastWriteRaw(String str) throws IOException {
        int ptr = this.mOutputPtr;
        int len = str.length();
        if (ptr + len >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            if (len > this.mOutputBufLen) {
                this.writeRaw(str, 0, len);
                return;
            }
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        this.mOutputPtr += len;
        char[] buf = this.mOutputBuffer;
        for (int i = 0; i < len; ++i) {
            buf[ptr++] = str.charAt(i);
        }
    }

    protected int verifyCDataContent(String content) {
        int ix;
        if (content != null && content.length() >= 3 && (ix = content.indexOf(93)) >= 0) {
            return content.indexOf("]]>", ix);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] c, int start, int end) {
        if (c != null) {
            start += 2;
            while (start < end) {
                char ch = c[start];
                if (ch == ']') {
                    ++start;
                    continue;
                }
                if (ch == '>' && c[start - 1] == ']' && c[start - 2] == ']') {
                    return start - 2;
                }
                start += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String content) {
        int ix = content.indexOf(45);
        if (ix >= 0 && ix < content.length() - 1) {
            ix = content.indexOf("--", ix);
        }
        return ix;
    }

    protected void writeSegmentedCData(String content, int index) throws IOException {
        int start = 0;
        while (index >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(content, start, index + 2 - start);
            this.fastWriteRaw("]]>");
            start = index + 2;
            index = content.indexOf("]]>", start);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(content, start, content.length() - start);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] c, int start, int len, int index) throws IOException {
        int end = start + len;
        while (index >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(c, start, index + 2 - start);
            this.fastWriteRaw("]]>");
            start = index + 2;
            index = this.verifyCDataContent(c, start, end);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(c, start, end - start);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String content, int index) throws IOException {
        int len = content.length();
        if (index == len - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(content, 0, len);
            this.fastWriteRaw(" -->");
            return;
        }
        int start = 0;
        while (index >= 0) {
            this.fastWriteRaw("<!--");
            this.writeRaw(content, start, index + 1 - start);
            this.fastWriteRaw(' ');
            start = index + 1;
            index = content.indexOf("--", start);
        }
        this.writeRaw(content, start, len - start);
        if (content.charAt(len - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    public static int guessEncodingBitSize(String enc) {
        if (enc == null || enc.length() == 0) {
            return 16;
        }
        if ((enc = CharsetNames.normalize(enc)) == "UTF-8") {
            return 16;
        }
        if (enc == "ISO-8859-1") {
            return 8;
        }
        if (enc == "US-ASCII") {
            return 7;
        }
        if (enc == "UTF-16" || enc == "UTF-16BE" || enc == "UTF-16LE" || enc == "UTF-32BE" || enc == "UTF-32LE") {
            return 16;
        }
        return 8;
    }

    protected final void writeAsEntity(int c) throws IOException {
        int ptr = this.mOutputPtr;
        char[] cbuf = this.mOutputBuffer;
        if (ptr + 8 >= cbuf.length) {
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        cbuf[ptr++] = 38;
        cbuf[ptr++] = 35;
        cbuf[ptr++] = 120;
        if (c < 16) {
            cbuf[ptr++] = (char)(c < 10 ? 48 + c : 87 + c);
        } else {
            int digits = c < 256 ? 2 : (c < 4096 ? 3 : (c < 65536 ? 4 : 6));
            ptr += digits;
            for (int i = 1; i <= digits; ++i) {
                int digit = c & 0xF;
                c >>= 4;
                cbuf[ptr - i] = (char)(digit < 10 ? 48 + digit : 87 + digit);
            }
        }
        cbuf[ptr++] = 59;
        this.mOutputPtr = ptr;
    }
}

