/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jndi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jndi.JNDIContext;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicEntity;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.IAttributeContainer;
import org.eclipse.higgins.idas.spi.IEntityContainer;
import org.eclipse.higgins.idas.spi.MetadataNotification;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDP;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;

public class JNDIEntity
extends BasicEntity
implements IEntity {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$cp$jndi$JNDIEntity == null ? (class$org$eclipse$higgins$idas$cp$jndi$JNDIEntity = JNDIEntity.class$("org.eclipse.higgins.idas.cp.jndi.JNDIEntity")) : class$org$eclipse$higgins$idas$cp$jndi$JNDIEntity).getName());
    private JNDIContext _context;
    private SearchResult _jndiResult;
    private IAttributePDPs _attrPDPs;
    private String _entityID;
    private URI _type;
    private IEntityContainer _container;
    private Vector _readListJNDI = new Vector();
    private boolean _bReadAllJNDI = false;
    private String _searchBase;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jndi$JNDIEntity;

    public JNDIEntity(JNDIContext jndiContext, SearchResult jndiResult, String searchBase, IAttributePDPs attrPDPs) throws IdASException {
        super((IContext)jndiContext);
        this._context = jndiContext;
        this._container = jndiContext;
        this._jndiResult = jndiResult;
        this._searchBase = searchBase;
        this._attrPDPs = attrPDPs;
    }

    public JNDIEntity(JNDIContext jndiContext, URI type, String entityID, IAttributePDPs attrPDPs) throws IdASException {
        super((IContext)jndiContext, type, entityID);
        this._context = jndiContext;
        this._container = jndiContext;
        this._entityID = this._context.consumerEntityIDToProvider(entityID);
        this._type = type;
        this._attrPDPs = attrPDPs;
    }

    public JNDIEntity(JNDIContext jndiContext, IEntity copyFrom, IAttributePDPs attrPDPs) throws IdASException {
        super((IContext)jndiContext, copyFrom.getEntityType(), copyFrom.getEntityID());
        this._context = jndiContext;
        this._container = jndiContext;
        this._entityID = this._context.consumerEntityIDToProvider(copyFrom.getEntityID());
        this._type = copyFrom.getEntityType();
        this._attrPDPs = attrPDPs;
    }

    private String _getNameInNamespace(SearchResult jndiResult) {
        String retStr = this._jndiResult.getName();
        if (retStr.length() == 0) {
            retStr = this._searchBase;
        } else if (this._searchBase.length() > 0) {
            retStr = retStr + "," + this._searchBase;
        }
        return retStr;
    }

    public String getEntityID() throws IdASException {
        if (this._entityID == null) {
            if (this._jndiResult != null) {
                this._entityID = this._context.providerEntityIDToConsumer(this._getNameInNamespace(this._jndiResult));
            } else {
                throw new IdASException("No entity ID is set.");
            }
        }
        return this._entityID;
    }

    public URI getEntityType() throws IdASException {
        if (this._type == null) {
            if (this._jndiResult != null) {
                this._type = this._context.getSearchResultType(this._jndiResult);
            } else {
                throw new IdASException("No entity type set.");
            }
        }
        return this._type;
    }

    public Iterator getAttributes() throws IdASException {
        BasicAttributeSet attrSet = this.getBasicAttributeSet();
        boolean bHasItems = attrSet.getAttributes().hasNext();
        if (!this._bReadAllJNDI && this._jndiResult != null) {
            Attributes jndiAttrs = this._jndiResult.getAttributes();
            NamingEnumeration<? extends Attribute> jndiEnum = jndiAttrs.getAll();
            try {
                while (jndiEnum.hasMore()) {
                    Attribute jndiAttr = jndiEnum.next();
                    NamingEnumeration<?> jndiAttrValEnum = jndiAttr.getAll();
                    URI attrURI = new URI(jndiAttr.getID());
                    BasicAttribute attr = null;
                    if (bHasItems && attrSet.getAttribute(attrURI) != null) continue;
                    attr = attrSet.addUnnotifiedAttribute(attrURI);
                    while (jndiAttrValEnum.hasMore()) {
                        Object jndiValue = jndiAttrValEnum.next();
                        if (jndiValue instanceof String) {
                            this._log.debug((Object)("Attr: " + jndiAttr.getID() + " is a String"));
                            attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)((String)jndiValue));
                            continue;
                        }
                        if (jndiValue instanceof byte[]) {
                            this._log.debug((Object)("Attr: " + jndiAttr.getID() + " is a byte[]"));
                            attr.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)((byte[])jndiValue));
                            continue;
                        }
                        this._log.debug((Object)jndiValue.getClass().toString());
                        attr.addSimpleValue(new URI("http://www.w3.org/2001/XMLSchema#any"), jndiValue);
                    }
                    attr.setContainer((IAttributeContainer)attrSet);
                    this._readListJNDI.add(attrURI);
                }
                this._bReadAllJNDI = true;
            }
            catch (NamingException e) {
                throw new IdASException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new IdASException((Throwable)e);
            }
        }
        return new BasicAttributePDPIter(this._attrPDPs, null, null, attrSet.getAttributes(), true);
    }

    public IAttribute getAttribute(URI consumerAttrName) throws IdASException {
        IAttribute retAttr;
        block11: {
            retAttr = null;
            BasicAttributeSet attrSet = this.getBasicAttributeSet();
            try {
                Iterator itr = this._attrPDPs.consumerIDToProviders(consumerAttrName);
                URI providerAttrName = null;
                while (itr.hasNext()) {
                    providerAttrName = (URI)itr.next();
                    if (this._readListJNDI.contains(providerAttrName)) {
                        retAttr = attrSet.getAttribute(providerAttrName);
                        this._log.debug((Object)(providerAttrName + " already placed attrSet, container: " + ((BasicAttribute)retAttr).getContainer()));
                        break;
                    }
                    retAttr = attrSet.getAttribute(providerAttrName);
                    if (retAttr != null) {
                        this._log.debug((Object)(providerAttrName + " already added attrSet, container: " + ((BasicAttribute)retAttr).getContainer()));
                        break;
                    }
                    if (this._jndiResult == null) continue;
                    BasicAttribute attr = null;
                    Attributes jndiAttrs = this._jndiResult.getAttributes();
                    NamingEnumeration<? extends Attribute> jndiEnum = jndiAttrs.getAll();
                    while (jndiEnum.hasMore()) {
                        Attribute jndiAttr = jndiEnum.next();
                        URI attrURI = new URI(jndiAttr.getID());
                        if (providerAttrName.compareTo((Object)attrURI) != 0) continue;
                        NamingEnumeration<?> jndiAttrValEnum = jndiAttr.getAll();
                        attr = attrSet.addUnnotifiedAttribute(attrURI);
                        while (jndiAttrValEnum.hasMore()) {
                            Object jndiValue = jndiAttrValEnum.next();
                            if (jndiValue instanceof String) {
                                this._log.debug((Object)("Attr: " + jndiAttr.getID() + " is a String"));
                                attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)((String)jndiValue));
                                continue;
                            }
                            if (jndiValue instanceof byte[]) {
                                this._log.debug((Object)("Attr: " + jndiAttr.getID() + " is a byte[]"));
                                attr.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)((byte[])jndiValue));
                                continue;
                            }
                            this._log.debug((Object)jndiValue.getClass().toString());
                            attr.addSimpleValue(new URI("http://www.w3.org/2001/XMLSchema#any"), jndiValue);
                        }
                        attr.setContainer((IAttributeContainer)attrSet);
                        retAttr = attr;
                        this._readListJNDI.add(attrURI);
                        this._log.debug((Object)("Placed [" + attr.getAttrID().toString() + "] into attrSet, container: " + ((BasicAttribute)retAttr).getContainer()));
                        break block11;
                    }
                }
            }
            catch (NamingException e) {
                throw new IdASException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new IdASException((Throwable)e);
            }
        }
        if (retAttr != null) {
            return new BasicAttributePDP(this._attrPDPs, null, null, retAttr, true);
        }
        return retAttr;
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        BasicAttributePDP attrPDP;
        BasicAttributeSet attrSet = this.getBasicAttributeSet();
        IAttribute attr = attrSet.getAttribute((attrPDP = new BasicAttributePDP(this._attrPDPs, null, null, copyFrom, false)).getAttrID());
        if (attr != null) {
            return attr;
        }
        return super.addAttribute((IAttribute)attrPDP);
    }

    public IAttribute addAttribute(URI type) throws IdASException, InvalidTypeException {
        URI providerType;
        Iterator itr = this._attrPDPs.consumerIDToProviders(type);
        BasicAttributeSet attrSet = this.getBasicAttributeSet();
        IAttribute attr = attrSet.getAttribute(providerType = (URI)itr.next());
        if (attr != null) {
            return attr;
        }
        return super.addAttribute(providerType);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        Iterator itr = this._attrPDPs.consumerIDToProviders(attrID);
        if (itr != null) {
            URI providerType = (URI)itr.next();
            super.removeAttribute(providerType);
        } else {
            super.removeAttribute(attrID);
        }
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        BasicAttributePDP attrPDP = new BasicAttributePDP(this._attrPDPs, null, null, attr, false);
        super.removeAttributeValue((IAttribute)attrPDP);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        Iterator itr = this._attrPDPs.consumerIDToProviders(attrID);
        if (itr != null) {
            URI providerType = (URI)itr.next();
            super.removeAttributeValue(providerType, value);
        } else {
            super.removeAttributeValue(attrID, value);
        }
    }

    public IEntityModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            this._container.updateNotification(new EntityNotification((IEntity)this, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE", null, null));
        }
    }

    public void updateNotification(AttributeNotification attrNotif) throws IdASException {
        this._log.debug((Object)("Received attribute update notification - " + attrNotif.getAction() + ", " + attrNotif.getAttr().getAttrID().toString()));
        this._log.debug((Object)("_containter " + (this._container != null ? this._container.toString() : "null")));
        if (this._container != null) {
            this._container.updateNotification(new EntityNotification((IEntity)this, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY", attrNotif, null));
        }
    }

    public void updateNotification(MetadataNotification metaNotif) throws IdASException {
        if (this._container != null) {
            this._container.updateNotification(new EntityNotification((IEntity)this, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_METADATA_NOTIFY", null, metaNotif));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

