/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jndi;

import com.novell.ldap.LDAPLocalException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import openxdas.XDasException;
import openxdas.XDasRecord;
import openxdas.XDasSession;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.bandit.util.jndi.RfcFilter;
import org.bandit.util.misc.CIStringKey;
import org.bandit.util.misc.NonEscapedAttrXMLWriter;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.tree.DefaultDocumentType;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.common.AuthNDigestMaterials;
import org.eclipse.higgins.idas.common.AuthNLeastPrivilegedUserMaterials;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.cp.jndi.JNDIContextModel;
import org.eclipse.higgins.idas.cp.jndi.JNDIEntity;
import org.eclipse.higgins.idas.cp.jndi.LDAPHigginsSSLSocketFactoryProducer;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicFilter;
import org.eclipse.higgins.idas.spi.BasicFilterAssertion;
import org.eclipse.higgins.idas.spi.BasicFilterAttributeAssertion;
import org.eclipse.higgins.idas.spi.BasicFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.spi.BasicValueBase64Binary;
import org.eclipse.higgins.idas.spi.BasicValueHexBinary;
import org.eclipse.higgins.idas.spi.BasicValueLanguage;
import org.eclipse.higgins.idas.spi.BasicValueNCName;
import org.eclipse.higgins.idas.spi.BasicValueNMTOKEN;
import org.eclipse.higgins.idas.spi.BasicValueName;
import org.eclipse.higgins.idas.spi.BasicValueNormalizedString;
import org.eclipse.higgins.idas.spi.BasicValueString;
import org.eclipse.higgins.idas.spi.BasicValueToken;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPAttributePDPs;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;
import org.eclipse.higgins.util.socket.HigginsSSLSocketFactory;

public class JNDIContext
extends BasicContext {
    private Logger _log;
    private LdapContext _ctx;
    private Map _contextSettings;
    private Map _connectionSettings;
    private Hashtable _env;
    private HashSet _metaData;
    private HashMap _schemaAttrDomainHashMap;
    private HashMap _schemaAttrCaseHashMap;
    private HashMap _syntaxHashMap;
    private IContextId _contextID;
    private boolean _bIsOpen;
    private String _currAddr;
    private String _entityID;
    private String _contextURIs;
    private String _contextTypes;
    private XDasSession _xdasSession;
    private Object _identity;
    private boolean _bStartTLS;
    private StartTlsResponse _tls;
    public static final String consumerEntityIDToProvider = "consumerEntityIDToProvider";
    public static final String providerEntityIDToConsumer = "providerEntityIDToConsumer";
    public static final String consumerEntityTypeToProvider = "consumerEntityTypeToProvider";
    public static final String providerEntityTypeToConsumer = "providerEntityTypeToConsumer";
    public static final String consumerAIDToProvider = "consumerAIDToProvider";
    public static final String providerAIDToConsumer = "providerAIDToConsumer";
    public static final String consumerATypeToProvider = "consumerATypeToProvider";
    public static final String providerATypeToConsumer = "providerATypeToConsumer";
    public static final String consumerAValueToProvider = "consumerAValueToProvider";
    public static final String providerAValueToConsumer = "providerAValueToConsumer";
    private JScriptExec _consumerEntityIDToProviderExec;
    private JScriptExec _providerEntityIDToConsumerExec;
    private JScriptExec _consumerEntityTypeToProviderExec;
    private JScriptExec _providerEntityTypeToConsumerExec;
    private JScriptCPAttributePDPs _attrPDPs;
    private boolean _bSetupPDPs;
    static /* synthetic */ Class class$0;

    public JNDIContext(IContextId contextID) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.jndi.JNDIContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = Logger.getLogger((String)clazz.getName());
        this._bIsOpen = false;
        this._contextURIs = "";
        this._contextTypes = "";
        this._bStartTLS = false;
        this._bSetupPDPs = true;
        int iLoop = 0;
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure((Appender)new NullAppender());
        }
        this._contextID = contextID;
        this._contextSettings = contextID.getConfiguration();
        this._connectionSettings = (Map)this._contextSettings.get("Connection");
        if (this._connectionSettings == null) {
            throw new IdASException("No JNDI connection settings specified");
        }
        this._env = new Hashtable();
        URI[] contextURIs = this._contextID.getUris();
        iLoop = 0;
        while (iLoop < contextURIs.length) {
            this._contextURIs = String.valueOf(this._contextURIs) + contextURIs[iLoop].toString() + ", ";
            ++iLoop;
        }
        String[] contextTypes = this._contextID.getTypes();
        iLoop = 0;
        while (iLoop < contextTypes.length) {
            this._contextTypes = String.valueOf(this._contextTypes) + contextTypes[iLoop] + ", ";
            ++iLoop;
        }
        this._initSyntaxMap();
        this._initXDASSession();
    }

    private void _initXDASSession() throws IdASException {
        try {
            this._xdasSession = new XDasSession("Higgins IdAS JNDI Context Provider", null, null, null, null, null);
        }
        catch (XDasException e) {
            throw new IdASException((Throwable)e);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {}
    }

    private void _initSyntaxMap() {
        this._syntaxHashMap = new HashMap();
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.3", new SyntaxMap("Attribute Type Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.6", new SyntaxMap("Bit String", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.7", new SyntaxMap("Boolean", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.11", new SyntaxMap("Country String", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.14", new SyntaxMap("Delivery Method", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.15", new SyntaxMap("Directory String", "&higgins;NormalizedStringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.16", new SyntaxMap("DIT Content Rule Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.17", new SyntaxMap("DIT Structure Rule Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.12", new SyntaxMap("DN", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.21", new SyntaxMap("Enhanced Guide", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.22", new SyntaxMap("Facsimile Telephone Number", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.23", new SyntaxMap("Fax", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.24", new SyntaxMap("Generalized Time", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.25", new SyntaxMap("Guide", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.26", new SyntaxMap("IA5 String", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.27", new SyntaxMap("Integer", "&higgins;IntegerSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.28", new SyntaxMap("JPEG", "&higgins;Base64BinarySimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.54", new SyntaxMap("LDAP Syntax Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.30", new SyntaxMap("Matching Rule Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.31", new SyntaxMap("Matching Rule Use Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.34", new SyntaxMap("Name and Optional UID", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.35", new SyntaxMap("Name Form Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.36", new SyntaxMap("Numeric String", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.37", new SyntaxMap("Object Class Description", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.40", new SyntaxMap("Octet String", "&higgins;Base64BinarySimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.38", new SyntaxMap("OID", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.39", new SyntaxMap("Other Mailbox", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.41", new SyntaxMap("Postal Address", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.44", new SyntaxMap("Printable String", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.58", new SyntaxMap("Substring Assertion", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.50", new SyntaxMap("Telephone Number", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.51", new SyntaxMap("Teletex Terminal Identifier", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.52", new SyntaxMap("Telex Number", "&higgins;StringSimpleAttribute"));
        this._syntaxHashMap.put("1.3.6.1.4.1.1466.115.121.1.53", new SyntaxMap("UTC Time", "&higgins;StringSimpleAttribute"));
    }

    private void _emitXDASRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._xdasSession != null) {
            if (sTargetInfo == null) {
                sTargetInfo = "";
            }
            if (sEventInfo == null) {
                sEventInfo = "";
            }
            try {
                XDasRecord xdasRecord = this._xdasSession.XDasStartRecord(iEventNumber, iOutcome, null, null, sEventInfo);
                xdasRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                xdasRecord.setTargetInfo(null, this._contextURIs, this._contextTypes, null, null, sTargetInfo);
                xdasRecord.commit();
            }
            catch (XDasException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    private String _lookupEntity(IFilter lookupFilter) throws IdASException {
        String entityID = null;
        if (lookupFilter != null) {
            Iterator entities = this.getEntities(lookupFilter);
            while (entities.hasNext()) {
                IEntity entity = (IEntity)entities.next();
                if (entityID == null) {
                    entityID = entity.getEntityID();
                    continue;
                }
                throw new IdASException("Non-unique identity from AuthN materials.");
            }
        }
        return entityID;
    }

    public String open(Object identity) throws IdASException {
        boolean bSetupContext;
        if (this._bIsOpen) {
            throw new ContextOpenException();
        }
        boolean bl = bSetupContext = this._identity == null;
        if (bSetupContext || !this._identity.equals(identity)) {
            Map envSettings;
            Map jsPolicySettings;
            if (this._bSetupPDPs && (jsPolicySettings = (Map)this._contextSettings.get("JSPolicyAction")) != null) {
                this._consumerEntityIDToProviderExec = (JScriptExec)jsPolicySettings.get(consumerEntityIDToProvider);
                this._providerEntityIDToConsumerExec = (JScriptExec)jsPolicySettings.get(providerEntityIDToConsumer);
                this._consumerEntityTypeToProviderExec = (JScriptExec)jsPolicySettings.get(consumerEntityTypeToProvider);
                this._providerEntityTypeToConsumerExec = (JScriptExec)jsPolicySettings.get(providerEntityTypeToConsumer);
                this._attrPDPs = new JScriptCPAttributePDPs((JScriptExec)jsPolicySettings.get(consumerAIDToProvider), (JScriptExec)jsPolicySettings.get(providerAIDToConsumer), (JScriptExec)jsPolicySettings.get(consumerATypeToProvider), (JScriptExec)jsPolicySettings.get(providerATypeToConsumer), (JScriptExec)jsPolicySettings.get(consumerAValueToProvider), (JScriptExec)jsPolicySettings.get(providerAValueToConsumer), false);
                this._bSetupPDPs = false;
            }
            if ((envSettings = (Map)this._contextSettings.get("env")) != null) {
                Set envSet = envSettings.entrySet();
                Iterator iter = envSet.iterator();
                while (iter.hasNext()) {
                    Map.Entry envEntry = iter.next();
                    this._env.put(envEntry.getKey(), envEntry.getValue());
                }
            }
            BasicFilter lookupFilter = null;
            this._identity = identity;
            if (identity instanceof AuthNNamePasswordMaterials) {
                this._env.put("java.naming.security.authentication", "simple");
                this._entityID = ((AuthNNamePasswordMaterials)identity).getUsername();
                this._env.put("java.naming.security.principal", this.consumerEntityIDToProvider(this._entityID));
                this._env.put("java.naming.security.credentials", ((AuthNNamePasswordMaterials)identity).getPassword());
            } else if (identity instanceof AuthNDigestMaterials) {
                BasicValueBase64Binary base64Value = new BasicValueBase64Binary(((AuthNDigestMaterials)identity).getSHA1Digest(), null);
                BasicFilterAttributeAssertion attrAssertion = new BasicFilterAttributeAssertion();
                attrAssertion.setID(URI.create("cardKeyHash"));
                attrAssertion.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
                attrAssertion.setAssertionValue((IAttributeValue)new BasicValueString(base64Value.getLexical(), null));
                lookupFilter = new BasicFilter();
                lookupFilter.setAssertion((IFilterAssertion)attrAssertion);
            } else if (identity instanceof AuthNLeastPrivilegedUserMaterials) {
                this._entityID = (String)this._env.get("java.naming.security.principal");
            } else if (identity instanceof AuthNAnonymousMaterials) {
                this._env.put("java.naming.security.authentication", "none");
                Object obj = this._env.get("java.naming.security.principal");
                this._env.remove(obj);
                obj = this._env.get("java.naming.security.credentials");
                this._env.remove(obj);
            } else {
                throw new NotImplementedException("Unsupported AuthN materials: " + identity.toString());
            }
            try {
                if (bSetupContext) {
                    this._setupContext();
                    String str = (String)this._env.get("org.eclipse.higgins.idas.cp.jndi.startTLS");
                    if (str != null && str.compareTo("true") == 0) {
                        SSLSession sess;
                        this._bStartTLS = true;
                        this._tls = (StartTlsResponse)this._ctx.extendedOperation(new StartTlsRequest());
                        String trustStore = (String)this._env.get("org.eclipse.higgins.idas.cp.jndi.trustStore");
                        if (trustStore != null) {
                            this._setupCustomSSLSocketFactory(trustStore);
                            sess = this._tls.negotiate((SSLSocketFactory)((HigginsSSLSocketFactory)LDAPHigginsSSLSocketFactoryProducer.getDefault()));
                        } else {
                            sess = this._tls.negotiate();
                        }
                        this._log.debug((Object)("Start TLS request successful: Host (" + sess.getPeerHost() + ")" + ", Protocol (" + sess.getProtocol() + ")"));
                    }
                    this._emitXDASRecord(0x1000007, 0, this._identity.toString(), null, null);
                    this._log.debug((Object)("Context opened: " + this._contextURIs + " as: " + this._identity.toString()));
                } else {
                    Iterator envIter = this._env.entrySet().iterator();
                    while (envIter.hasNext()) {
                        Map.Entry me = envIter.next();
                        this._ctx.addToEnvironment((String)me.getKey(), me.getValue());
                    }
                    this._ctx.reconnect(null);
                }
            }
            catch (NamingException e) {
                this._handleNamingException(e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
            this._bIsOpen = true;
            if (lookupFilter != null) {
                this._entityID = this._lookupEntity((IFilter)lookupFilter);
                if (this._entityID == null) {
                    throw new IdASException("AuthN materials produced no Entity ID: " + identity.toString());
                }
            }
        } else {
            this._bIsOpen = true;
        }
        return this._entityID;
    }

    private void _handleNamingException(NamingException e) throws IdASException {
        if (e instanceof CommunicationException) {
            this._destroyContext();
        } else {
            if (e instanceof NameAlreadyBoundException) {
                throw new EntityExistsException((Throwable)e);
            }
            if (e instanceof javax.naming.AuthenticationException) {
                throw new AuthenticationException((Throwable)e);
            }
            if (e instanceof NameNotFoundException) {
                throw new NoSuchEntityException((Throwable)e);
            }
        }
        throw new IdASException((Throwable)e);
    }

    private void _setupCustomSSLSocketFactory(String trustStore) throws IdASException {
        HigginsSSLSocketFactory socketFactory = (HigginsSSLSocketFactory)LDAPHigginsSSLSocketFactoryProducer.getDefault();
        socketFactory.setKeyStore(new File(trustStore));
    }

    private void _setupContext() throws IdASException {
        List addressList = (List)this._connectionSettings.get("AddressList");
        if (addressList == null || addressList.size() == 0) {
            throw new IdASException("No JNDI service addresses configured.");
        }
        int iLoop = 0;
        while (iLoop < addressList.size()) {
            String addr = (String)addressList.get(iLoop);
            if (this._currAddr == null || this._currAddr.compareTo(addr) != 0) {
                this._currAddr = addr;
                this._log.debug((Object)("Attempting to create initial context: " + this._currAddr));
                String ssl = null;
                String trustStore = (String)this._env.get("org.eclipse.higgins.idas.cp.jndi.trustStore");
                if (trustStore != null && (this._currAddr.indexOf("ldaps") == 0 || (ssl = (String)this._env.get("java.naming.security.protocol")) != null && ssl.equals("ssl"))) {
                    this._env.put("java.naming.ldap.factory.socket", "org.eclipse.higgins.idas.cp.jndi.LDAPSSLSocketFactory");
                    this._setupCustomSSLSocketFactory(trustStore);
                } else {
                    this._env.remove("java.naming.ldap.factory.socket");
                }
                String jndiProvider = (String)this._connectionSettings.get("jndiProvider");
                if (jndiProvider == null) {
                    jndiProvider = "com.sun.jndi.ldap.LdapCtxFactory";
                }
                this._env.put("java.naming.factory.initial", jndiProvider);
                this._env.put("java.naming.provider.url", this._currAddr);
                try {
                    this._ctx = new InitialLdapContext(this._env, null);
                    break;
                }
                catch (CommunicationException communicationException) {
                }
                catch (NamingException e) {
                    throw new IdASException((Throwable)e);
                }
            }
            ++iLoop;
        }
        if (iLoop == addressList.size()) {
            throw new IdASException("Unable to connect to any specified JNDI service address.");
        }
    }

    private void _destroyContext() throws IdASException {
        try {
            if (this._bStartTLS) {
                this._tls.close();
                this._bStartTLS = false;
            }
            this._ctx.close();
        }
        catch (NamingException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
        this._identity = null;
        this._ctx = null;
    }

    private String _getIdentity() {
        return this._identity == null ? null : this._identity.toString();
    }

    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        this._bIsOpen = false;
        this._emitXDASRecord(0x1000008, 0, this._getIdentity(), null, null);
        this._log.debug((Object)("Context closed: " + this._contextURIs + " as: " + this._getIdentity()));
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    public String getAuthEntityID() {
        return this._entityID;
    }

    private DOMDocument _getInitialSchemaDoc() {
        DOMDocument doc = new DOMDocument();
        Vector<InternalEntityDecl> entityDeclList = new Vector<InternalEntityDecl>();
        entityDeclList.add(new InternalEntityDecl("ldapowl", "http://www.eclipse.org/higgins/ontologies/2006/higgins/ldap#"));
        entityDeclList.add(new InternalEntityDecl("higgins", "http://www.eclipse.org/higgins/ontologies/2006/higgins#"));
        entityDeclList.add(new InternalEntityDecl("xsd", "http://www.w3.org/2001/XMLSchema#"));
        DefaultDocumentType docType = new DefaultDocumentType();
        docType.setInternalDeclarations(entityDeclList);
        docType.setName("rdf:RDF");
        doc.setDocType((DocumentType)docType);
        doc.addComment("\r\n*******************************************************************************\r\n* Copyright (c) 2006 Novell Inc.\r\n* All rights reserved. This document and accompanying materials\r\n* are made available under the terms of the Eclipse Public License v1.0\r\n* which accompanies this distribution, and is available at\r\n* http://www.eclipse.org/legal/epl-v10.html\r\n*\r\n* Contributors:\r\n*     Tom Doman\r\n*     Jim Sermersheim\r\n*******************************************************************************\r\n");
        DOMElement elem = (DOMElement)doc.addElement("rdf:RDF");
        elem.addAttribute("xml:base", "http://www.eclipse.org/higgins/ontologies/2006/higgins/ldap#");
        elem.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        elem.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        elem.addNamespace("owl", "http://www.w3.org/2002/07/owl#");
        elem.addNamespace("ldapowl", "http://www.eclipse.org/higgins/ontologies/2006/higgins/ldap#");
        DOMElement ontElem = (DOMElement)elem.addElement("owl:Ontology");
        ontElem.addAttribute("rdf:about", "");
        DOMElement childElem = (DOMElement)ontElem.addElement("rdfs:label");
        childElem.addText("Dynamically Generated Higgins-based LDAP Ontology (Context: " + this._contextURIs + ")");
        childElem = (DOMElement)ontElem.addElement("owl:imports");
        childElem.addAttribute("rdf:resource", "http://www.eclipse.org/higgins/ontologies/2006/higgins");
        ontElem = (DOMElement)elem.addElement("owl:Ontology");
        ontElem.addAttribute("rdf:about", "http://www.eclipse.org/higgins/ontologies/2006/higgins");
        return doc;
    }

    private void _getSchemaClass(DOMDocument schemaDoc, String schemaName, Attributes attrs) throws IdASException {
        try {
            boolean bFoundSup = false;
            DOMElement rootElem = (DOMElement)schemaDoc.getRootElement();
            rootElem.addComment(schemaName);
            DOMElement classElem = (DOMElement)rootElem.addElement("owl:Class");
            classElem.addAttribute("rdf:ID", "class_" + schemaName);
            DOMElement childElem = (DOMElement)classElem.addElement("rdfs:label");
            childElem.addAttribute("rdf:datatype", "&xsd;string");
            childElem.addText(schemaName);
            NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
            while (attrEnum.hasMore()) {
                Attribute attr = attrEnum.next();
                NamingEnumeration<?> attrVals = attr.getAll();
                if (attr.getID().compareTo("SUP") == 0) {
                    childElem = (DOMElement)classElem.addElement("rdfs:subClassOf");
                    childElem.addAttribute("rdf:resource", "#class_" + attrVals.next());
                    bFoundSup = true;
                    continue;
                }
                if (attr.getID().compareTo("NUMERICOID") == 0) {
                    Object oid = attrVals.next();
                    childElem = (DOMElement)classElem.addElement("owl:equivalentClass");
                    childElem.addAttribute("rdf:resource", "urn:oid:" + oid);
                    DOMElement oidClassElem = (DOMElement)rootElem.addElement("owl:Class");
                    oidClassElem.addAttribute("rdf:about", "urn:oid:" + oid);
                    childElem = (DOMElement)oidClassElem.addElement("rdfs:label");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText(schemaName);
                    continue;
                }
                if (attr.getID().compareTo("MAY") == 0) {
                    while (attrVals.hasMore()) {
                        this._addAttributeDomain(schemaName, (String)attrVals.next());
                    }
                    continue;
                }
                if (attr.getID().compareTo("MUST") == 0) {
                    while (attrVals.hasMore()) {
                        String attrName = (String)attrVals.next();
                        DOMElement subClassElem = (DOMElement)classElem.addElement("rdfs:subClassOf");
                        DOMElement restrictElem = (DOMElement)subClassElem.addElement("owl:Restriction");
                        this._addAttributeDomain(schemaName, attrName);
                        childElem = (DOMElement)restrictElem.addElement("owl:onProperty");
                        childElem.addAttribute("rdf:resource", attrName);
                        childElem = (DOMElement)restrictElem.addElement("owl:minCardinality");
                        childElem.addAttribute("rdf:datatype", "&xsd;nonNegativeInteger");
                        childElem.addText("1");
                    }
                    continue;
                }
                if (attr.getID().compareTo("DESC") == 0) {
                    childElem = (DOMElement)classElem.addElement("rdfs:comment");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText((String)attrVals.next());
                    continue;
                }
                if (attr.getID().compareTo("NAME") != 0 && attr.getID().compareTo("ABSTRACT") != 0 && attr.getID().compareTo("STRUCTURAL") != 0 && attr.getID().compareTo("AUXILIARY") != 0 && attr.getID().compareTo("OBSOLETE") != 0) continue;
            }
            if (!bFoundSup) {
                childElem = (DOMElement)classElem.addElement("rdfs:subClassOf");
                childElem.addAttribute("rdf:resource", "&higgins;Entity");
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
    }

    private String _getAttributeNameCase(String attrName) {
        CIStringKey ciAttrName;
        String attrCaseName = attrName;
        if (this._schemaAttrCaseHashMap != null && (attrCaseName = (String)this._schemaAttrCaseHashMap.get(ciAttrName = new CIStringKey(attrName))) == null) {
            this._schemaAttrCaseHashMap.put(ciAttrName, attrName);
            attrCaseName = attrName;
        }
        return attrCaseName;
    }

    private void _addAttributeDomain(String className, String attrName) {
        CIStringKey ciAttrName = new CIStringKey(attrName);
        Vector<String> classNameVect = (Vector<String>)this._schemaAttrDomainHashMap.get(ciAttrName);
        if (classNameVect == null) {
            classNameVect = new Vector<String>();
        }
        classNameVect.add(className);
        this._schemaAttrDomainHashMap.put(ciAttrName, classNameVect);
    }

    private Vector _getAttrDomains(String schemaName) {
        CIStringKey ciAttrName = new CIStringKey(schemaName);
        return (Vector)this._schemaAttrDomainHashMap.get(ciAttrName);
    }

    private void _getSchemaAttrDef(DOMDocument schemaDoc, String schemaName, Attributes attrs) throws IdASException {
        DOMElement rootElem = (DOMElement)schemaDoc.getRootElement();
        rootElem.addComment(schemaName);
        DOMElement propertyElem = (DOMElement)rootElem.addElement("owl:ObjectProperty");
        propertyElem.addAttribute("rdf:about", schemaName);
        DOMElement childElem = (DOMElement)propertyElem.addElement("rdfs:label");
        childElem.addAttribute("rdf:datatype", "&xsd;string");
        childElem.addText(schemaName);
        try {
            boolean bFoundSup = false;
            NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
            while (attrEnum.hasMore()) {
                Attribute attr = attrEnum.next();
                NamingEnumeration<?> attrVals = attr.getAll();
                if (attr.getID().compareTo("SUP") == 0) {
                    childElem = (DOMElement)propertyElem.addElement("rdfs:subPropertyOf");
                    childElem.addAttribute("rdf:resource", (String)attrVals.next());
                    bFoundSup = true;
                    continue;
                }
                if (attr.getID().compareTo("NUMERICOID") == 0) {
                    Object oid = attrVals.next();
                    childElem = (DOMElement)propertyElem.addElement("owl:equivalentProperty");
                    childElem.addAttribute("rdf:resource", "urn:oid:" + oid);
                    DOMElement oidPropertyElem = (DOMElement)rootElem.addElement("owl:ObjectProperty");
                    oidPropertyElem.addAttribute("rdf:about", "urn:oid:" + oid);
                    childElem = (DOMElement)oidPropertyElem.addElement("rdfs:label");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText(schemaName);
                    continue;
                }
                if (attr.getID().compareTo("SYNTAX") == 0) {
                    String syntax;
                    String syntaxOID = syntax = (String)attrVals.next();
                    if (syntax.indexOf(123) > 0) {
                        syntaxOID = syntax.substring(0, syntax.indexOf(123));
                    }
                    childElem = (DOMElement)propertyElem.addElement("rdfs:range");
                    SyntaxMap syntaxMap = (SyntaxMap)this._syntaxHashMap.get(syntaxOID);
                    childElem.addAttribute("rdf:resource", syntaxMap == null ? "urn:oid:" + syntaxOID : "#" + syntaxMap.getURLName());
                    continue;
                }
                if (attr.getID().compareTo("DESC") == 0) {
                    childElem = (DOMElement)propertyElem.addElement("rdfs:comment");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText((String)attrVals.next());
                    continue;
                }
                if (attr.getID().compareTo("SINGLE-VALUE") == 0) {
                    DOMElement singleValElem = (DOMElement)rootElem.addElement("rdf:Description");
                    singleValElem.addAttribute("rdf:about", "#class_top");
                    DOMElement subClassElem = (DOMElement)singleValElem.addElement("rdfs:subClassOf");
                    DOMElement restrictElem = (DOMElement)subClassElem.addElement("owl:Restriction");
                    childElem = (DOMElement)restrictElem.addElement("owl:maxCardinality");
                    childElem.addText("1");
                    childElem = (DOMElement)restrictElem.addElement("owl:onProperty");
                    childElem.addAttribute("rdf:resource", schemaName);
                    continue;
                }
                if (attr.getID().compareTo("NAME") == 0) {
                    String name = (String)attrVals.next();
                    if (schemaName.compareTo(name) == 0) continue;
                    childElem = (DOMElement)propertyElem.addElement("owl:equivalentProperty");
                    childElem.addAttribute("rdf:resource", name);
                    DOMElement equivPropertyElem = (DOMElement)rootElem.addElement("owl:ObjectProperty");
                    equivPropertyElem.addAttribute("rdf:about", name);
                    childElem = (DOMElement)equivPropertyElem.addElement("rdfs:label");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText(schemaName);
                    continue;
                }
                if (attr.getID().compareTo("EQUALITY") != 0 && attr.getID().compareTo("ORDERING") != 0 && attr.getID().compareTo("SUBSTRING") != 0 && attr.getID().compareTo("COLLECTIVE") != 0 && attr.getID().compareTo("NO-USER-MODIFICATION") != 0 && attr.getID().compareTo("USAGE") != 0 && attr.getID().compareTo("OBSOLETE") != 0) continue;
            }
            Vector attrClasses = this._getAttrDomains(schemaName);
            if (attrClasses != null) {
                int iLoop = 0;
                while (iLoop < attrClasses.size()) {
                    childElem = (DOMElement)propertyElem.addElement("rdfs:domain");
                    childElem.addAttribute("rdf:resource", "#class_" + attrClasses.get(iLoop));
                    ++iLoop;
                }
            }
            if (!bFoundSup) {
                childElem = (DOMElement)propertyElem.addElement("rdfs:subPropertyOf");
                childElem.addAttribute("rdf:resource", "&higgins;attribute");
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
    }

    private void _getSchemaSyntaxDef(DOMDocument schemaDoc, String schemaName, Attributes attrs) throws IdASException {
        try {
            DOMElement rootElem = (DOMElement)schemaDoc.getRootElement();
            SyntaxMap syntaxMap = (SyntaxMap)this._syntaxHashMap.get(schemaName);
            if (syntaxMap == null) {
                rootElem.addComment(schemaName);
            } else {
                rootElem.addComment(syntaxMap.getLabel());
            }
            DOMElement classElem = (DOMElement)rootElem.addElement("owl:Class");
            if (syntaxMap == null) {
                classElem.addAttribute("rdf:about", "urn:oid:" + schemaName);
            } else {
                classElem.addAttribute("rdf:ID", syntaxMap.getURLName());
            }
            DOMElement childElem = (DOMElement)classElem.addElement("rdfs:label");
            childElem.addAttribute("rdf:datatype", "&xsd;string");
            childElem.addText(syntaxMap == null ? schemaName : syntaxMap.getLabel());
            childElem = (DOMElement)classElem.addElement("rdfs:subClassOf");
            childElem.addAttribute("rdf:resource", syntaxMap == null ? "&higgins;StringSimpleAttribute" : syntaxMap.getOWLType());
            NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
            while (attrEnum.hasMore()) {
                Attribute attr = attrEnum.next();
                NamingEnumeration<?> attrVals = attr.getAll();
                if (attr.getID().compareTo("DESC") == 0) {
                    childElem = (DOMElement)classElem.addElement("rdfs:comment");
                    childElem.addAttribute("rdf:datatype", "&xsd;string");
                    childElem.addText((String)attrVals.next());
                    continue;
                }
                if (attr.getID().compareTo("NUMERICOID") != 0 || syntaxMap == null) continue;
                Object oid = attrVals.next();
                childElem = (DOMElement)classElem.addElement("owl:equivalentClass");
                childElem.addAttribute("rdf:resource", "urn:oid:" + oid);
                DOMElement oidClassElem = (DOMElement)rootElem.addElement("owl:Class");
                oidClassElem.addAttribute("rdf:about", "urn:oid:" + oid);
                childElem = (DOMElement)oidClassElem.addElement("rdfs:label");
                childElem.addAttribute("rdf:datatype", "&xsd;string");
                childElem.addText(syntaxMap.getLabel());
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
    }

    public String getSchema() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._schemaAttrDomainHashMap == null) {
            this._schemaAttrDomainHashMap = new HashMap();
        } else {
            this._schemaAttrDomainHashMap.clear();
        }
        if (this._schemaAttrCaseHashMap == null) {
            this._schemaAttrCaseHashMap = new HashMap();
        } else {
            this._schemaAttrCaseHashMap.clear();
        }
        DOMDocument schemaDoc = this._getInitialSchemaDoc();
        try {
            DirContext schemaCtx;
            try {
                schemaCtx = this._ctx.getSchema(this._ctx.getNameInNamespace());
            }
            catch (NamingException namingException) {
                try {
                    schemaCtx = this._ctx.getSchema("");
                }
                catch (NamingException namingException2) {
                    schemaCtx = this._ctx.getSchema(this.consumerEntityIDToProvider(this._entityID));
                }
            }
            Vector<String> schemaContainers = new Vector<String>();
            schemaContainers.add("ClassDefinition");
            schemaContainers.add("AttributeDefinition");
            schemaContainers.add("SyntaxDefinition");
            int iLoop = 0;
            while (iLoop < schemaContainers.size()) {
                NamingEnumeration<NameClassPair> list = schemaCtx.list((String)schemaContainers.elementAt(iLoop));
                DOMElement rootElem = (DOMElement)schemaDoc.getRootElement();
                rootElem.addComment((String)schemaContainers.elementAt(iLoop));
                while (list.hasMore()) {
                    NameClassPair ncPair = list.next();
                    DirContext ctx = (DirContext)schemaCtx.lookup(schemaContainers.elementAt(iLoop) + "/" + ncPair.getName());
                    Attributes attrs = ctx.getAttributes("");
                    if (((String)schemaContainers.elementAt(iLoop)).compareTo("ClassDefinition") == 0) {
                        this._getSchemaClass(schemaDoc, ncPair.getName(), attrs);
                        continue;
                    }
                    if (((String)schemaContainers.elementAt(iLoop)).compareTo("AttributeDefinition") == 0) {
                        this._getSchemaAttrDef(schemaDoc, ncPair.getName(), attrs);
                        continue;
                    }
                    if (((String)schemaContainers.elementAt(iLoop)).compareTo("SyntaxDefinition") != 0) continue;
                    this._getSchemaSyntaxDef(schemaDoc, ncPair.getName(), attrs);
                }
                ++iLoop;
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
        StringWriter strWriter = new StringWriter();
        NonEscapedAttrXMLWriter xmlWriter = new NonEscapedAttrXMLWriter((Writer)strWriter);
        try {
            xmlWriter.write((Document)schemaDoc);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
        return strWriter.toString();
    }

    public IEntity getEntity(String entityID) throws IdASException {
        return this.getEntity(entityID, null);
    }

    public IEntity getEntity(String entityID, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        this._emitXDASRecord(0x1000005, 0, this._getIdentity(), entityID, null);
        this._log.debug((Object)("Searching for Entity: " + entityID + " as: " + this._getIdentity() + " in context: " + this._contextURIs));
        JNDIEntity entity = null;
        SearchControls controls = new SearchControls();
        HashSet providerSelectionList = new HashSet();
        if (consumerSelectionList != null) {
            this._mapConsumerSelectionList(consumerSelectionList, providerSelectionList);
            this._addRequiredAttrs(providerSelectionList);
            URI[] uriAttrArray = providerSelectionList.toArray(new URI[0]);
            String[] attrArray = new String[uriAttrArray.length];
            int iLoop = 0;
            while (iLoop < uriAttrArray.length) {
                attrArray[iLoop] = uriAttrArray[iLoop].toString();
                ++iLoop;
            }
            controls.setReturningAttributes(attrArray);
        }
        controls.setSearchScope(0);
        try {
            String realEntityID = this.consumerEntityIDToProvider(entityID);
            NamingEnumeration<SearchResult> results = this._ctx.search(realEntityID, "(objectclass=*)", controls);
            if (results.hasMore()) {
                SearchResult result = results.next();
                entity = new JNDIEntity(this, result, realEntityID, (IAttributePDPs)this._attrPDPs);
                if (results.hasMore()) {
                    throw new IdASException("Non-unique Entity ID");
                }
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
        return entity;
    }

    private void _mapConsumerSelectionList(Iterator consumerSelectionList, HashSet providerSelectionList) throws IdASException {
        while (consumerSelectionList.hasNext()) {
            URI consumerAttrName = (URI)consumerSelectionList.next();
            Vector providerAttrList = this._mapConsumerAttrName(consumerAttrName);
            if (providerAttrList != null) {
                Iterator providerAttrIter = providerAttrList.iterator();
                while (providerAttrIter.hasNext()) {
                    URI providerAttrName = (URI)providerAttrIter.next();
                    providerSelectionList.add(providerAttrName);
                }
                continue;
            }
            providerSelectionList.add(consumerAttrName);
        }
    }

    private Vector _mapConsumerAttrName(URI consumerAttrName) throws IdASException {
        Vector<URI> attrList = new Vector<URI>();
        if (this._attrPDPs != null) {
            Iterator itr = this._attrPDPs.consumerIDToProviders(consumerAttrName);
            while (itr.hasNext()) {
                attrList.add((URI)itr.next());
            }
        } else {
            attrList.add(consumerAttrName);
        }
        return attrList;
    }

    private void _addRequiredAttrs(HashSet providerSelectionList) throws IdASException {
        try {
            providerSelectionList.add(new URI("objectclass"));
            providerSelectionList.add(new URI("structuralObjectClass"));
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
    }

    private void _convertFilter(BasicFilter basicFilter, RfcFilter ldapFilter) throws IdASException {
        try {
            BasicFilterAssertion assertion = (BasicFilterAssertion)basicFilter.getAssertion();
            if (assertion != null) {
                URI attrURI = assertion.getID();
                if (assertion instanceof BasicFilterEntityTypeAssertion) {
                    attrURI = new URI("objectclass");
                }
                String comparator = assertion.getComparator();
                int rfcType = this._mapComparator(comparator);
                Vector providerAttrList = this._mapConsumerAttrName(attrURI);
                if (providerAttrList.size() > 1) {
                    ldapFilter.startNestedFilter(rfcType);
                }
                Iterator providerAttrIter = providerAttrList.iterator();
                block6: while (providerAttrIter.hasNext()) {
                    URI attrName = (URI)providerAttrIter.next();
                    if (assertion instanceof BasicFilterAttributeAssertion) {
                        BasicFilterAttributeAssertion attributeAssertion = (BasicFilterAttributeAssertion)assertion;
                        IAttributeValue assertionValue = attributeAssertion.getAssertionValue();
                        if (assertionValue == null) {
                            switch (rfcType) {
                                case 7: {
                                    ldapFilter.addPresent(attrName.toString());
                                    continue block6;
                                }
                                default: {
                                    throw new NotImplementedException("Comparator (" + comparator + ") not supported.");
                                }
                            }
                        }
                        if (assertionValue.isSimple()) {
                            if (rfcType == 3 || rfcType == 5 || rfcType == 6) {
                                if (assertionValue instanceof BasicValueBase64Binary || assertionValue instanceof BasicValueHexBinary) {
                                    ByteBuffer byteBuf = (ByteBuffer)((ISimpleAttrValue)assertionValue).getData();
                                    ldapFilter.addAttributeValueAssertion(rfcType, attrName.toString(), byteBuf.array());
                                    continue;
                                }
                                if (assertionValue instanceof BasicValueString || assertionValue instanceof BasicValueNormalizedString || assertionValue instanceof BasicValueToken || assertionValue instanceof BasicValueLanguage || assertionValue instanceof BasicValueNMTOKEN || assertionValue instanceof BasicValueName || assertionValue instanceof BasicValueNCName) {
                                    ldapFilter.addAttributeValueAssertion(rfcType, attrName.toString(), ((String)((ISimpleAttrValue)assertionValue).getData()).getBytes());
                                    continue;
                                }
                                ldapFilter.addAttributeValueAssertion(rfcType, attrName.toString(), ((ISimpleAttrValue)assertionValue).getLexical().getBytes());
                                continue;
                            }
                            throw new NotImplementedException("Comparator (" + comparator + ") not supported.");
                        }
                        throw new NotImplementedException("Complex assertion values in filters not supported.");
                    }
                    if (!(assertion instanceof BasicFilterEntityTypeAssertion)) continue;
                    BasicFilterEntityTypeAssertion entityTypeAssertion = (BasicFilterEntityTypeAssertion)assertion;
                    ldapFilter.addAttributeValueAssertion(3, attrName.toString(), this.consumerEntityTypeToProvider(entityTypeAssertion.getAssertionValue()).toString().getBytes());
                }
                if (providerAttrList.size() > 1) {
                    ldapFilter.endNestedFilter(rfcType);
                }
            } else {
                String operator = basicFilter.getOperator();
                int rfcType = this._mapOperator(operator);
                ldapFilter.startNestedFilter(rfcType);
                Iterator filters = basicFilter.getFilters();
                while (filters.hasNext()) {
                    IFilter filter = (IFilter)filters.next();
                    this._convertFilter((BasicFilter)filter, ldapFilter);
                }
                ldapFilter.endNestedFilter(rfcType);
            }
        }
        catch (LDAPLocalException e) {
            throw new IdASException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
    }

    private int _mapComparator(String comparator) {
        int iRet = -1;
        if (comparator.compareTo("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality") == 0) {
            iRet = 3;
        } else if (comparator.compareTo("urn:org.eclipse.higgins.idas.api.comparator.attribute.greaterOrEqual") == 0) {
            iRet = 5;
        } else if (comparator.compareTo("urn:org.eclipse.higgins.idas.api.comparator.attribute.lessOrEqual") == 0) {
            iRet = 6;
        } else if (comparator.compareTo("urn:org.eclipse.higgins.idas.api.comparator.attribute.present") == 0) {
            iRet = 7;
        } else if (comparator.compareTo("urn:org.eclipse.higgins.idas.api.comparator.attribute.substring") == 0) {
            iRet = 4;
        }
        return iRet;
    }

    private int _mapOperator(String operator) throws IdASException {
        int iRet = -1;
        if (operator.compareTo("urn:eclipse.higgins.idas.OP_NOT") == 0) {
            iRet = 2;
        } else if (operator.compareTo("urn:eclipse.higgins.idas.OP_AND") == 0) {
            iRet = 0;
        } else if (operator.compareTo("urn:eclipse.higgins.idas.OP_OR") == 0) {
            iRet = 1;
        } else {
            throw new NotImplementedException("Operator (" + operator + ") not supported.");
        }
        return iRet;
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        this._emitXDASRecord(0x1000005, 0, this._getIdentity(), filter == null ? null : filter.toString(), null);
        this._log.debug("Searching for Entities matching filter: " + filter == null ? null : String.valueOf(filter.toString()) + " as: " + this._getIdentity() + " in context: " + this._contextURIs);
        HashSet<JNDIEntity> subs = new HashSet<JNDIEntity>();
        String strFilter = "(objectclass=*)";
        if (filter != null) {
            BasicFilter basicFilter = (BasicFilter)filter;
            RfcFilter ldapFilter = new RfcFilter();
            this._convertFilter(basicFilter, ldapFilter);
            strFilter = ldapFilter.filterToString();
            this._log.debug((Object)("LDAP String Filter: " + strFilter));
        }
        try {
            SearchControls controls = new SearchControls();
            HashSet providerSelectionList = new HashSet();
            if (consumerSelectionList != null) {
                this._mapConsumerSelectionList(consumerSelectionList, providerSelectionList);
                this._addRequiredAttrs(providerSelectionList);
                URI[] uriAttrArray = providerSelectionList.toArray(new URI[0]);
                String[] attrArray = new String[uriAttrArray.length];
                int iLoop = 0;
                while (iLoop < uriAttrArray.length) {
                    attrArray[iLoop] = uriAttrArray[iLoop].toString();
                    ++iLoop;
                }
                controls.setReturningAttributes(attrArray);
            }
            controls.setSearchScope(2);
            String searchBase = this._getSearchBase();
            NamingEnumeration<SearchResult> results = this._ctx.search(searchBase, strFilter, controls);
            while (results.hasMore()) {
                SearchResult result = results.next();
                JNDIEntity entity = new JNDIEntity(this, result, searchBase, (IAttributePDPs)this._attrPDPs);
                subs.add(entity);
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
        return subs.iterator();
    }

    public void removeEntity(String entityID) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        try {
            this._ctx.destroySubcontext(entityID);
        }
        catch (NamingException e) {
            throw new IdASException((Throwable)e);
        }
    }

    public Iterator getMetadataSet() throws IdASException {
        return this._getMetadataSet().iterator();
    }

    private HashSet _getMetadataSet() throws IdASException {
        if (this._metaData == null) {
            this._metaData = new HashSet();
        }
        return this._metaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI getSearchResultType(SearchResult searchResult) throws IdASException {
        String structuralClass;
        block7: {
            structuralClass = null;
            String resultName = searchResult.getName();
            try {
                Attribute ocAttr = this._getObjectClass(searchResult);
                NamingEnumeration<?> jndiAttrValEnum = ocAttr.getAll();
                if (ocAttr.size() == 1) {
                    structuralClass = (String)jndiAttrValEnum.next();
                    break block7;
                }
                while (jndiAttrValEnum.hasMore()) {
                    String jndiValue = (String)jndiAttrValEnum.next();
                    if (!this._isStructural(resultName, jndiValue, ocAttr)) continue;
                    structuralClass = jndiValue;
                    break;
                }
            }
            catch (NamingException e) {
                this._handleNamingException(e);
            }
        }
        if (structuralClass == null) {
            throw new IdASException("No structural class found.");
        }
        URI uriType = null;
        try {
            uriType = new URI(structuralClass);
            return this.providerEntityTypeToConsumer(uriType);
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
    }

    private boolean _isStructural(String entityName, String className, Attribute ocAttr) throws IdASException {
        boolean bRet;
        block4: {
            bRet = false;
            try {
                NamingEnumeration<?> jndiAttrValEnum = ocAttr.getAll();
                while (jndiAttrValEnum.hasMore()) {
                    DirContext schemaCtx;
                    DirContext ctx;
                    Attributes attrs;
                    String supClass;
                    Object jndiValue = jndiAttrValEnum.next();
                    if (className.compareToIgnoreCase((String)jndiValue) == 0 || (supClass = this._getSuperiorClass(attrs = (ctx = (DirContext)(schemaCtx = this._ctx.getSchema(this._ctx.getNameInNamespace())).lookup("ClassDefinition/" + jndiValue)).getAttributes(""))) == null || className.compareToIgnoreCase(supClass) != 0) {
                        continue;
                    }
                    break block4;
                }
                bRet = true;
            }
            catch (NamingException e) {
                this._handleNamingException(e);
            }
        }
        return bRet;
    }

    private String _getSuperiorClass(Attributes attrs) throws IdASException {
        String superiorClass = null;
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        try {
            while (attrEnum.hasMore()) {
                Attribute attr = attrEnum.next();
                NamingEnumeration<?> attrVals = attr.getAll();
                if (attr.getID().compareTo("SUP") == 0) {
                    superiorClass = (String)attrVals.next();
                    continue;
                }
                if (attr.getID().compareTo("AUXILIARY") != 0 && attr.getID().compareTo("ABSTRACT") != 0) continue;
                superiorClass = null;
                break;
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
        return superiorClass;
    }

    private Attribute _getObjectClass(SearchResult searchResult) throws IdASException {
        Attributes jndiAttrs = searchResult.getAttributes();
        Attribute retAttr = null;
        boolean bFoundStructural = false;
        NamingEnumeration<? extends Attribute> jndiEnum = jndiAttrs.getAll();
        try {
            while (jndiEnum.hasMore()) {
                Attribute jndiAttr = jndiEnum.next();
                if (jndiAttr.getID().compareToIgnoreCase("structuralObjectClass") == 0) {
                    bFoundStructural = true;
                    NamingEnumeration<?> jndiAttrValEnum = jndiAttr.getAll();
                    if (jndiAttr.size() != 1) {
                        throw new IdASException("Only 1 value expected, found: " + jndiAttr.size());
                    }
                    String jndiValue = (String)jndiAttrValEnum.next();
                    if (jndiValue.compareToIgnoreCase("top") == 0) continue;
                    retAttr = jndiAttr;
                } else {
                    if (jndiAttr.getID().compareToIgnoreCase("objectclass") != 0) continue;
                    retAttr = jndiAttr;
                    if (!bFoundStructural) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (NamingException e) {
            this._handleNamingException(e);
        }
        if (retAttr == null) {
            throw new IdASException("No structural or object class found.");
        }
        return retAttr;
    }

    protected String consumerEntityIDToProvider(String entityID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._consumerEntityIDToProviderExec, (String)"consumerID", (String)entityID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected String providerEntityIDToConsumer(String entityID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._providerEntityIDToConsumerExec, (String)"providerID", (String)entityID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI consumerEntityTypeToProvider(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._consumerEntityTypeToProviderExec, (String)"consumerType", (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI providerEntityTypeToConsumer(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._providerEntityTypeToConsumerExec, (String)"providerType", (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    public IEntity addEntity(URI type, String entityID) throws IdASException {
        JNDIEntity entity = new JNDIEntity(this, this.consumerEntityTypeToProvider(type), entityID, (IAttributePDPs)this._attrPDPs);
        this.updateNotification(new EntityNotification((IEntity)entity, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD", null, null));
        return entity;
    }

    protected DirContext getDirContext() {
        return this._ctx;
    }

    private String _getSearchBase() {
        String searchBase = (String)this._connectionSettings.get("searchBase");
        if (searchBase == null) {
            searchBase = "";
        }
        return searchBase;
    }

    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        JNDIEntity entity = new JNDIEntity(this, copyFrom, (IAttributePDPs)this._attrPDPs);
        this.updateNotification(new EntityNotification((IEntity)entity, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD", null, null));
        return entity;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyUpdates() throws IdASException {
        Hashtable updateList = super.getUpdateList();
        try {
            this._log.debug((Object)"Applying updates ...");
            int iCount = 0;
            Iterator keyIter = updateList.keySet().iterator();
            while (true) {
                block6: {
                    if (keyIter.hasNext()) break block6;
                }
                String entityID = (String)keyIter.next();
                this._updateEntry(entityID, (Vector)updateList.get(entityID));
                ++iCount;
            }
            this._log.debug((Object)(String.valueOf(iCount) + (iCount == 1 ? " change " : " changes ") + "applied"));
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            updateList.clear();
            throw throwable;
        }
        {
            Object var5_8 = null;
            updateList.clear();
            return;
        }
    }

    private void _updateEntry(String entityID, Vector entityNotifs) throws IdASException {
        block5: {
            try {
                EntityNotification[] aEntityNotifs = entityNotifs.toArray(new EntityNotification[entityNotifs.size()]);
                this._log.debug((Object)("Updating entry [" + entityID + "], " + aEntityNotifs[0].getAction()));
                if (aEntityNotifs[0].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD") == 0) {
                    BasicAttributes jndiAttrs = this._entityNotificationToBasicAttributes(aEntityNotifs);
                    this._ctx.createSubcontext(this.consumerEntityIDToProvider(entityID), (Attributes)jndiAttrs);
                    break block5;
                }
                if (aEntityNotifs[0].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE") == 0) {
                    this._ctx.destroySubcontext(this.consumerEntityIDToProvider(aEntityNotifs[0].getEntity().getEntityID()));
                    break block5;
                }
                if (aEntityNotifs[0].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY") == 0) {
                    Vector jndiMods = this._entityNotificationToModificationItems(aEntityNotifs);
                    this._ctx.modifyAttributes(this.consumerEntityIDToProvider(entityID), jndiMods.toArray(new ModificationItem[jndiMods.size()]));
                    break block5;
                }
                throw new NotImplementedException(aEntityNotifs[0].getAction());
            }
            catch (NamingException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BasicAttributes _entityNotificationToBasicAttributes(EntityNotification[] entityNotifs) throws IdASException {
        BasicAttributes jndiAttrs = new BasicAttributes();
        jndiAttrs.put(new BasicAttribute("objectClass", entityNotifs[0].getEntity().getEntityType().toString()));
        int iLoop = 0;
        while (iLoop < entityNotifs.length) {
            if (entityNotifs[iLoop].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY") == 0) {
                AttributeNotification attrNotif = entityNotifs[iLoop].getAttributeNotification();
                if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY") == 0) {
                    AttributeValueNotification attrValNotif = attrNotif.getAttributeValueNotification();
                    if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD") != 0) {
                        throw new IdASException("Unallowed attribute value notification type during entity creation: " + attrValNotif.getAction());
                    }
                    if (jndiAttrs.get(attrNotif.getAttr().getAttrID().toString()) == null) {
                        jndiAttrs.put(this._IAttributeToAttribute(attrNotif.getAttr()));
                    }
                } else {
                    if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD") != 0) throw new IdASException("Unallowed attribute notification type during entity creation: " + attrNotif.getAction());
                    if (jndiAttrs.get(attrNotif.getAttr().getAttrID().toString()) == null) {
                        jndiAttrs.put(this._IAttributeToAttribute(attrNotif.getAttr()));
                    }
                }
            } else if (entityNotifs[iLoop].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD") != 0) {
                throw new IdASException("Unallowed entity notification type during entity creation: " + entityNotifs[iLoop].getAction());
            }
            ++iLoop;
        }
        return jndiAttrs;
    }

    private Vector _entityNotificationToModificationItems(EntityNotification[] entityNotifs) throws IdASException {
        Vector<ModificationItem> jndiMods = new Vector<ModificationItem>();
        this._log.debug((Object)("Entity notifications: " + entityNotifs.length));
        int iLoop = 0;
        while (iLoop < entityNotifs.length) {
            AttributeNotification attrNotif = entityNotifs[iLoop].getAttributeNotification();
            this._log.debug((Object)("Converting attribute notification to modification item: " + attrNotif.getAction() + ", " + attrNotif.getAttr().getAttrID().toString()));
            if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY") == 0) {
                jndiMods.add(this._attributeValueNotificationToModificationItem(attrNotif));
            } else if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE") == 0) {
                AttributeNotification addNotif = null;
                AttributeNotification addValueNotif = null;
                if (iLoop + 2 < entityNotifs.length) {
                    addNotif = entityNotifs[iLoop + 1].getAttributeNotification();
                    addValueNotif = entityNotifs[iLoop + 2].getAttributeNotification();
                }
                if (addNotif != null && addValueNotif != null && attrNotif.getAttr().getAttrID().toString().compareTo(addNotif.getAttr().getAttrID().toString()) == 0 && addNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD") == 0 && addValueNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY") == 0) {
                    Attribute attr = this._AttrNotifToJNDIAttr(addValueNotif);
                    jndiMods.add(new ModificationItem(2, attr));
                    iLoop += 2;
                } else {
                    jndiMods.add(new ModificationItem(3, new BasicAttribute(attrNotif.getAttr().getAttrID().toString())));
                }
            } else if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD") != 0) {
                throw new NotImplementedException(attrNotif.getAction());
            }
            ++iLoop;
        }
        return jndiMods;
    }

    private Attribute _AttrNotifToJNDIAttr(AttributeNotification attrNotif) throws IdASException {
        BasicAttribute attr = null;
        try {
            String attrID = attrNotif.getAttr().getAttrID().toString();
            attr = new BasicAttribute(attrID);
            AttributeValueNotification attrValNotif = attrNotif.getAttributeValueNotification();
            IAttributeValue attrVal = attrValNotif.getAttributeValue();
            URI providerType = (URI)this._mapConsumerAttrName(new URI(attrID)).firstElement();
            IAttributeValue providerVal = this._attrPDPs.consumerValueToProvider(attrVal.getDataType(), null, providerType, null, attrVal);
            if (!providerVal.isSimple()) {
                throw new NotImplementedException("Cannot convert complex attributes to JNDI attributes");
            }
            String strVal = ((ISimpleAttrValue)providerVal).getLexical();
            this._log.debug((Object)("Adding value to JNDI attribute: " + strVal));
            attr.add(strVal);
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
        return attr;
    }

    private ModificationItem _attributeValueNotificationToModificationItem(AttributeNotification attrNotif) throws IdASException {
        ModificationItem retModItem = null;
        Attribute attr = this._AttrNotifToJNDIAttr(attrNotif);
        AttributeValueNotification attrValNotif = attrNotif.getAttributeValueNotification();
        if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD") == 0) {
            retModItem = new ModificationItem(1, attr);
        } else if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE") == 0) {
            retModItem = new ModificationItem(3, attr);
        } else if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_SET_DATA") == 0) {
            retModItem = new ModificationItem(2, attr);
        } else {
            throw new NotImplementedException(attrValNotif.getAction());
        }
        return retModItem;
    }

    private Attribute _IAttributeToAttribute(IAttribute attr) throws IdASException {
        BasicAttribute jndiAttr = null;
        try {
            URI providerType = (URI)this._mapConsumerAttrName(new URI(attr.getAttrID().toString())).firstElement();
            jndiAttr = new BasicAttribute(providerType.toString());
            this._log.debug((Object)("Converting consumer attribute to provider attribute: " + attr.getAttrID().toString()));
            Iterator consumerVals = attr.getValues();
            while (consumerVals.hasNext()) {
                IAttributeValue consumerVal = (IAttributeValue)consumerVals.next();
                IAttributeValue providerVal = this._attrPDPs.consumerValueToProvider(consumerVal.getDataType(), null, providerType, null, consumerVal);
                if (providerVal.isSimple()) {
                    ISimpleAttrValue simpleVal = (ISimpleAttrValue)providerVal;
                    jndiAttr.add(simpleVal.getLexical());
                    continue;
                }
                throw new NotImplementedException("Cannot convert complex attributes to JNDI attributes: " + providerVal.getClass().toString() + ": " + providerVal.getDataType().toString());
            }
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
        return jndiAttr;
    }

    public IContextModel getContextModel() {
        return new JNDIContextModel(this);
    }

    private class SyntaxMap {
        private String _label;
        private String _urlName;
        private String _owlType;

        SyntaxMap(String label, String owlType) {
            this._label = label;
            this._urlName = label.replaceAll(" ", "");
            this._owlType = owlType;
        }

        public String getLabel() {
            return this._label;
        }

        public String getURLName() {
            return "syntax_" + this._urlName;
        }

        public String getOWLType() {
            return this._owlType;
        }
    }
}

